/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.util;

import com.ankmaniac.decofirmacraft.common.blocks.DFCBlocks;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class DFCHelpers {
    public static ResourceLocation identifier(String id) {
        return new ResourceLocation("dfc", id);
    }

    public static boolean isHoldingFluidContainerInOffhand(Player player) {
        ItemStack offHandItem = player.m_21206_();
        LazyOptional fluidHandlerCap = offHandItem.getCapability(ForgeCapabilities.FLUID_HANDLER);
        return fluidHandlerCap.isPresent();
    }

    public static FluidStack getFluidStack(JsonObject json) {
        String fluidName = json.get("fluid").getAsString();
        int amount = json.has("amount") ? json.get("amount").getAsInt() : 1000;
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null) {
            fluid = Fluids.f_76191_;
        }
        return new FluidStack(fluid, amount);
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        LazyOptional fluidHandlerCap;
        if (stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && (fluidHandlerCap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM)).isPresent()) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)fluidHandlerCap.orElseThrow(IllegalStateException::new);
            return fluidHandler.getFluidInTank(0);
        }
        return FluidStack.EMPTY;
    }

    public static Item getLeadedStainedGlass(DyeColor color) {
        return switch (color) {
            case DyeColor.WHITE -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.WHITE).get()).m_5456_();
            case DyeColor.ORANGE -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.ORANGE).get()).m_5456_();
            case DyeColor.MAGENTA -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.MAGENTA).get()).m_5456_();
            case DyeColor.LIGHT_BLUE -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.LIGHT_BLUE).get()).m_5456_();
            case DyeColor.YELLOW -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.YELLOW).get()).m_5456_();
            case DyeColor.LIME -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.LIME).get()).m_5456_();
            case DyeColor.PINK -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.PINK).get()).m_5456_();
            case DyeColor.GRAY -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.GRAY).get()).m_5456_();
            case DyeColor.LIGHT_GRAY -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.LIGHT_GRAY).get()).m_5456_();
            case DyeColor.CYAN -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.CYAN).get()).m_5456_();
            case DyeColor.PURPLE -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.PURPLE).get()).m_5456_();
            case DyeColor.BLUE -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.BLUE).get()).m_5456_();
            case DyeColor.BROWN -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.BROWN).get()).m_5456_();
            case DyeColor.GREEN -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.GREEN).get()).m_5456_();
            case DyeColor.RED -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.RED).get()).m_5456_();
            default -> ((Block)DFCBlocks.STAINED_LEADED_GLASS_PANE.get(DyeColor.BLACK).get()).m_5456_();
        };
    }
}

