/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.common.blocks.rock;

import com.ankmaniac.decofirmacraft.common.blocks.DFCBlocks;
import com.ankmaniac.decofirmacraft.common.blocks.rock.ColumnBlock;
import com.ankmaniac.decofirmacraft.common.blocks.rock.DFCRock;
import com.ankmaniac.decofirmacraft.common.blocks.rock.RoadBlock;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public enum CustomDFCRockBlocks implements StringRepresentable
{
    PILLAR((rock, self) -> new RotatedPillarBlock(CustomDFCRockBlocks.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), false),
    ROAD((rock, self) -> new RoadBlock(CustomDFCRockBlocks.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
    TILE((rock, self) -> new Block(CustomDFCRockBlocks.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
    THIN_OUTLINE((rock, self) -> new Block(CustomDFCRockBlocks.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), false),
    THICK_OUTLINE((rock, self) -> new Block(CustomDFCRockBlocks.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), false),
    COLUMN((rock, self) -> new ColumnBlock(CustomDFCRockBlocks.properties(rock).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), false);

    public static final CustomDFCRockBlocks[] VALUES;
    private final boolean variants;
    private final BiFunction<DFCRock, CustomDFCRockBlocks, Block> blockFactory;
    private final String serializedName;

    public static CustomDFCRockBlocks valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : PILLAR;
    }

    private static BlockBehaviour.Properties properties(DFCRock rock) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(rock.color()).m_60918_(SoundType.f_56742_).m_280658_(NoteBlockInstrument.BASEDRUM);
    }

    private CustomDFCRockBlocks(BiFunction<DFCRock, CustomDFCRockBlocks, Block> blockFactory, boolean variants) {
        this.blockFactory = blockFactory;
        this.variants = variants;
        this.serializedName = this.name().toLowerCase(Locale.ROOT);
    }

    public boolean hasVariants() {
        return this.variants;
    }

    public Block create(DFCRock rock) {
        return this.blockFactory.apply(rock, this);
    }

    public SlabBlock createSlab(DFCRock rock) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
        return new SlabBlock(properties);
    }

    public Supplier<? extends Block> getBlocks(DFCRock rock, CustomDFCRockBlocks type) {
        return (Supplier)DFCBlocks.CUSTOM_DFC_ROCK_BLOCKS.get((Object)rock).get((Object)type);
    }

    public StairBlock createStairs(DFCRock rock) {
        Supplier<BlockState> state = () -> this.getBlocks(rock, this).get().m_49966_();
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
        return new StairBlock(state, properties);
    }

    public WallBlock createWall(DFCRock rock) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
        return new WallBlock(properties);
    }

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        VALUES = CustomDFCRockBlocks.values();
    }
}

