/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.common.blocks;

import com.ankmaniac.decofirmacraft.common.blocks.DFCBlocks;
import com.ankmaniac.decofirmacraft.common.blocks.metal.DFCMetal;
import com.ankmaniac.decofirmacraft.common.items.DFCItems;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.common.fluids.ExtendedFluidType;
import net.dries007.tfc.common.fluids.FluidRegistryObject;
import net.dries007.tfc.common.fluids.FluidTypeClientProperties;
import net.dries007.tfc.common.fluids.MixingFluid;
import net.dries007.tfc.common.fluids.MoltenFluid;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DFCFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"dfc");
    public static final Map<DFCMetal.DFCDefault, FluidRegistryObject<ForgeFlowingFluid>> METALS = Helpers.mapOfKeys(DFCMetal.DFCDefault.class, metal -> DFCFluids.register("metal/dfc_" + metal.m_7912_(), properties -> properties.block((Supplier)DFCBlocks.DFC_METAL_FLUIDS.get(metal)).bucket((Supplier)DFCItems.DFC_METAL_FLUID_BUCKETS.get(metal)).explosionResistance(100.0f), DFCFluids.lavaLike().descriptionId("fluid.dfc.metal." + metal.m_7912_()).canConvertToSource(false), new FluidTypeClientProperties(0xFF000000 | metal.getColor(), TFCFluids.MOLTEN_STILL, TFCFluids.MOLTEN_FLOW, null, null), MoltenFluid.Source::new, MoltenFluid.Flowing::new));
    public static final FluidRegistryObject<ForgeFlowingFluid> PLASTER = DFCFluids.register("plaster", properties -> properties.block(DFCBlocks.PLASTER_FLUID).bucket(DFCItems.PLASTER_FLUID_BUCKET), DFCFluids.waterLike().descriptionId("fluid.dfc.plaster"), new FluidTypeClientProperties(-855617, (level, pos) -> level.m_6171_(pos, TFCColors.SALT_WATER) | 0xFF000000, TFCFluids.WATER_STILL, TFCFluids.WATER_FLOW, TFCFluids.WATER_OVERLAY, TFCFluids.UNDERWATER_LOCATION), MixingFluid.Source::new, MixingFluid.Flowing::new);
    public static final FluidRegistryObject<ForgeFlowingFluid> CONCRETE = DFCFluids.register("dfc_concrete", properties -> properties.block(DFCBlocks.CONCRETE_FLUID).bucket(DFCItems.CONCRETE_FLUID_BUCKET), DFCFluids.waterLike().descriptionId("fluid.dfc.concrete"), new FluidTypeClientProperties(-6644585, (level, pos) -> level.m_6171_(pos, TFCColors.SALT_WATER) | 0xFF000000, TFCFluids.WATER_STILL, TFCFluids.WATER_FLOW, TFCFluids.WATER_OVERLAY, TFCFluids.UNDERWATER_LOCATION), MixingFluid.Source::new, MixingFluid.Flowing::new);

    private static FluidType.Properties lavaLike() {
        return FluidType.Properties.create().adjacentPathType(BlockPathTypes.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).lightLevel(15).density(3000).viscosity(6000).temperature(1300).canConvertToSource(false).canDrown(false).canExtinguish(false).canHydrate(false).canPushEntity(false).canSwim(false).supportsBoating(false);
    }

    private static FluidType.Properties waterLike() {
        return FluidType.Properties.create().adjacentPathType(BlockPathTypes.WATER).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).canConvertToSource(true).canDrown(true).canExtinguish(true).canHydrate(false).canPushEntity(true).canSwim(true).supportsBoating(true);
    }

    private static <F extends FlowingFluid> FluidRegistryObject<F> register(String name, Consumer<ForgeFlowingFluid.Properties> builder, FluidType.Properties typeProperties, FluidTypeClientProperties clientProperties, Function<ForgeFlowingFluid.Properties, F> sourceFactory, Function<ForgeFlowingFluid.Properties, F> flowingFactory) {
        int index = name.lastIndexOf(47);
        String flowingName = index == -1 ? "flowing_" + name : name.substring(0, index) + "/flowing_" + name.substring(index + 1);
        return RegistrationHelpers.registerFluid((DeferredRegister)TFCFluids.FLUID_TYPES, FLUIDS, (String)name, (String)name, (String)flowingName, builder, () -> new ExtendedFluidType(typeProperties, clientProperties), sourceFactory, flowingFactory);
    }
}

