/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.bubbleschat.client;

import com.thomas7520.bubbleschat.BubblesConfig;
import com.thomas7520.bubbleschat.client.ClientBubblesUtil;
import com.thomas7520.bubbleschat.client.screen.ScreenConfig;
import com.thomas7520.bubbleschat.util.Bubble;
import com.thomas7520.bubbleschat.util.Message;
import com.thomas7520.bubbleschat.util.SpecColor;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class BubblesClientEvent {
    @SubscribeEvent
    public static void bubblesRenderEvent(RenderLivingEvent.Pre<Player, PlayerModel<Player>> event) {
        UUID uuid = event.getEntity().m_20148_();
        if (!ClientBubblesUtil.BUBBLES_SYNC.containsKey(uuid)) {
            return;
        }
        if (event.getEntity().m_20145_() || event.getEntity().m_21224_()) {
            return;
        }
        Bubble bubble = ClientBubblesUtil.BUBBLES_SYNC.get(uuid);
        long endTime = bubble.getMessages().getFirst().getStartTime() + TimeUnit.SECONDS.toMillis(((Integer)BubblesConfig.CLIENT.durationBubbles.get()).intValue());
        if (endTime < System.currentTimeMillis()) {
            ClientBubblesUtil.BUBBLES_SYNC.remove(event.getEntity().m_20148_());
            return;
        }
        int k = 0;
        for (Message message : new ArrayDeque<Message>(bubble.getMessages())) {
            long endTime2 = message.getStartTime() + TimeUnit.SECONDS.toMillis(((Integer)BubblesConfig.CLIENT.durationBubbles.get()).intValue());
            if (endTime2 < System.currentTimeMillis()) {
                bubble.getMessages().remove(message);
                continue;
            }
            ClientBubblesUtil.draw(message, bubble.getMessages(), event, endTime2, event.getEntity().m_20163_(), true, true, k == 0, k);
            ++k;
        }
    }

    @SubscribeEvent
    public static void onPress(InputEvent.Key event) {
        KeyMapping[] keyBindings = ClientBubblesUtil.keyBindings;
        if (keyBindings[0].m_90857_()) {
            Minecraft.m_91087_().m_91152_((Screen)new ScreenConfig());
        }
    }

    @SubscribeEvent
    public static void onServerQuit(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientBubblesUtil.serverSupport = false;
    }

    @SubscribeEvent
    public static void onChatReceived(ClientChatReceivedEvent event) {
        if (ClientBubblesUtil.serverSupport || !((Boolean)BubblesConfig.CLIENT.enableBubbles.get()).booleanValue()) {
            return;
        }
        boolean isSystem = event.getBoundChatType().f_240859_().f_237011_().f_238741_().equalsIgnoreCase("forge.chatType.system");
        if (isSystem && !((Boolean)BubblesConfig.CLIENT.forceFormatChat.get()).booleanValue()) {
            return;
        }
        String message = ChatFormatting.m_126649_((String)event.getMessage().getString());
        assert (Minecraft.m_91087_().f_91073_ != null && message != null);
        TreeMap players = new TreeMap(Comparator.comparingInt(String::length).thenComparing(Function.identity()).reversed());
        Minecraft.m_91087_().f_91073_.m_6907_().stream().filter(player -> !player.m_7755_().getString().isEmpty()).collect(Collectors.toList()).forEach(playerEntity -> players.put(playerEntity.m_7755_().getString(), playerEntity.m_20148_()));
        for (String arg : BubblesClientEvent.getMessage(message, false).split(" ")) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            if (!players.containsKey(arg)) continue;
            BubblesClientEvent.addBubbles(BubblesClientEvent.getMessage(message, true), (UUID)players.get(arg));
            return;
        }
        for (Map.Entry entry : players.entrySet()) {
            String text;
            String patternFormat = "\\b" + (String)entry.getKey() + "\\b";
            Pattern pattern = Pattern.compile(patternFormat);
            if (!pattern.matcher(BubblesClientEvent.getMessage(message, false)).find() || (text = BubblesClientEvent.getMessage(message, true)).isEmpty()) continue;
            BubblesClientEvent.addBubbles(BubblesClientEvent.getMessage(message, true), (UUID)entry.getValue());
            return;
        }
        if (!((Boolean)BubblesConfig.CLIENT.forceFormatChat.get()).booleanValue() || isSystem) {
            return;
        }
        String[] messageFormat = message.replace("<", "").replace(">", "").split(" ", 2);
        if (messageFormat.length < 2) {
            return;
        }
        String string = messageFormat[0];
        String text = messageFormat[1];
        if (players.containsKey(string)) {
            BubblesClientEvent.addBubbles(text, (UUID)players.get(string));
        }
    }

    public static String getMessage(String text, boolean suffix) {
        String[] formats;
        for (String format : formats = new String[]{":", ">", ">>", "\u00bb", "\u203a", "U+27A2", "\u27a2", "\u21dd"}) {
            if (text.split(format).length <= 1) continue;
            return suffix ? text.split(format)[1].trim() : text.split(format)[0].trim();
        }
        return "";
    }

    public static void addBubbles(String text, UUID uuid) {
        if (text.isEmpty()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        Bubble bubble = ClientBubblesUtil.BUBBLES_SYNC.get(uuid);
        if (bubble == null) {
            bubble = new Bubble(startTime, text);
            ClientBubblesUtil.BUBBLES_SYNC.put(uuid, bubble);
        } else {
            if (bubble.getMessages().size() == ((Integer)BubblesConfig.CLIENT.maxBubblesStack.get()).intValue()) {
                bubble.getMessages().removeLast();
            }
            bubble.getMessages().addFirst(new Message(startTime, text, new SpecColor((List)BubblesConfig.CLIENT.colorOutline.get()), new SpecColor((List)BubblesConfig.CLIENT.colorInside.get()), new SpecColor((List)BubblesConfig.CLIENT.colorText.get())));
        }
    }
}

