/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.bubbleschat;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class BubblesConfig {
    public static final String CATEGORY_GENERAL = "general";
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Client {
        public ForgeConfigSpec.ConfigValue<List<Integer>> colorOutline;
        public ForgeConfigSpec.ConfigValue<List<Integer>> colorInside;
        public ForgeConfigSpec.ConfigValue<List<Integer>> colorText;
        public ForgeConfigSpec.IntValue durationBubbles;
        public ForgeConfigSpec.IntValue maxBubblesStack;
        public ForgeConfigSpec.IntValue lineWidth;
        public ForgeConfigSpec.IntValue sizeBubble;
        public ForgeConfigSpec.BooleanValue enableBubbles;
        public ForgeConfigSpec.BooleanValue canThroughBlocks;
        public ForgeConfigSpec.BooleanValue forceFormatChat;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push(BubblesConfig.CATEGORY_GENERAL);
            this.colorOutline = builder.comment("Adjust the color of the bubbles outline | args = r,g,b,a").define("outlineColor", new ArrayList());
            this.colorInside = builder.comment("Adjust the color of the bubbles inside | args = r,g,b,a").define("insideColor", new ArrayList());
            this.colorText = builder.comment("Adjust the color of the bubbles text | args = r,g,b,a").define("textColor", new ArrayList());
            this.durationBubbles = builder.comment("Adjust duration time of bubbles").defineInRange("durationBubbles", 10, 0, 60);
            this.maxBubblesStack = builder.comment("Max Bubbles Stackable on a player's head").defineInRange("maxBubblesStack", 0, 0, Integer.MAX_VALUE);
            this.lineWidth = builder.comment("Max line width").defineInRange("lineWidth", 150, 50, Integer.MAX_VALUE);
            this.sizeBubble = builder.comment("Size of bubble").defineInRange("sizeBubble", 0, 0, 20);
            this.enableBubbles = builder.comment("Enable Bubbles Listener").define("bubblesListener", true);
            this.canThroughBlocks = builder.comment("See the bubbles through blocks or not ( like name )").define("throughBlock", true);
            this.forceFormatChat = builder.comment("Force Format chat is bubbles don't appear").define("forceFormatChat", false);
        }
    }

    public static class Server {
        public ForgeConfigSpec.BooleanValue chatListener;
        public ForgeConfigSpec.ConfigValue<String> commandName;
        public ForgeConfigSpec.ConfigValue<String> messageSuccess;
        public ForgeConfigSpec.DoubleValue bubbleRange;
        public ForgeConfigSpec.BooleanValue canThroughBlocks;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push(BubblesConfig.CATEGORY_GENERAL);
            this.chatListener = builder.comment("Enable Chat Listener").define("chatListener", true);
            this.commandName = builder.comment("Create a custom command (empty = no command)").define("commandName", (Object)"");
            this.messageSuccess = builder.comment("Message sent when player performed command (empty = no message) You can add color (ex: &bBubbles created").define("messageSuccess", (Object)"");
            this.bubbleRange = builder.comment("Radius of the bubble sending to the players (packet)").defineInRange("bubbleRange", 50.0, 0.0, Double.MAX_VALUE);
            this.canThroughBlocks = builder.comment("Can players see the bubbles through blocks or not ( useful for server rp as example )").define("throughBlock", true);
        }
    }
}

