/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.gui.entries.BaseListCell;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class BaseListEntry<T, C extends BaseListCell, SELF extends BaseListEntry<T, C, SELF>>
extends TooltipListEntry<List<T>>
implements Expandable {
    protected static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    @NotNull
    protected final List<C> cells;
    @NotNull
    protected final List<GuiEventListener> widgets;
    @NotNull
    protected final List<NarratableEntry> narratables;
    protected boolean expanded;
    protected boolean insertButtonEnabled = true;
    protected boolean deleteButtonEnabled;
    protected boolean insertInFront;
    protected ListLabelWidget labelWidget;
    protected AbstractWidget resetWidget;
    @NotNull
    protected Function<SELF, C> createNewInstance;
    @NotNull
    protected Supplier<List<T>> defaultValue;
    @Nullable
    protected Component addTooltip = Component.m_237115_((String)"text.cloth-config.list.add");
    @Nullable
    protected Component removeTooltip = Component.m_237115_((String)"text.cloth-config.list.remove");

    @ApiStatus.Internal
    public BaseListEntry(@NotNull Component fieldName, @Nullable Supplier<Optional<Component[]>> tooltipSupplier, @Nullable Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, Component resetButtonKey) {
        this(fieldName, tooltipSupplier, defaultValue, createNewInstance, saveConsumer, resetButtonKey, false);
    }

    @ApiStatus.Internal
    public BaseListEntry(@NotNull Component fieldName, @Nullable Supplier<Optional<Component[]>> tooltipSupplier, @Nullable Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, Component resetButtonKey, boolean requiresRestart) {
        this(fieldName, tooltipSupplier, defaultValue, createNewInstance, saveConsumer, resetButtonKey, requiresRestart, true, true);
    }

    @ApiStatus.Internal
    public BaseListEntry(@NotNull Component fieldName, @Nullable Supplier<Optional<Component[]>> tooltipSupplier, @Nullable Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, Component resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.deleteButtonEnabled = deleteButtonEnabled;
        this.insertInFront = insertInFront;
        this.cells = Lists.newArrayList();
        this.labelWidget = new ListLabelWidget();
        this.widgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.labelWidget});
        this.narratables = Lists.newArrayList();
        this.resetWidget = Button.m_253074_((Component)resetButtonKey, widget -> {
            this.widgets.removeAll(this.cells);
            this.narratables.removeAll(this.cells);
            for (BaseListCell cell : this.cells) {
                cell.onDelete();
            }
            this.cells.clear();
            ((List)defaultValue.get()).stream().map(this::getFromValue).forEach(this.cells::add);
            for (BaseListCell cell : this.cells) {
                cell.onAdd();
            }
            this.widgets.addAll(this.cells);
            this.narratables.addAll(this.cells);
        }).m_252987_(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)resetButtonKey) + 6, 20).m_253136_();
        this.widgets.add((GuiEventListener)this.resetWidget);
        this.narratables.add((NarratableEntry)this.resetWidget);
        this.saveCallback = saveConsumer;
        this.createNewInstance = createNewInstance;
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded && this.isEnabled();
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean isEdited() {
        if (super.isEdited()) {
            return true;
        }
        return this.cells.stream().anyMatch(BaseListCell::isEdited);
    }

    public boolean isMatchDefault() {
        Optional<List<T>> defaultValueOptional = this.getDefaultValue();
        if (defaultValueOptional.isPresent()) {
            List value = (List)this.getValue();
            List<T> defaultValue = defaultValueOptional.get();
            if (value.size() != defaultValue.size()) {
                return false;
            }
            for (int i = 0; i < value.size(); ++i) {
                if (Objects.equals(value.get(i), defaultValue.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequiresRestart() {
        return this.cells.stream().anyMatch(BaseListCell::isRequiresRestart);
    }

    @Override
    public void setRequiresRestart(boolean requiresRestart) {
    }

    public abstract SELF self();

    public boolean isDeleteButtonEnabled() {
        return this.deleteButtonEnabled && this.isEnabled();
    }

    public boolean isInsertButtonEnabled() {
        return this.insertButtonEnabled && this.isEnabled();
    }

    public void setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        this.deleteButtonEnabled = deleteButtonEnabled;
    }

    public void setInsertButtonEnabled(boolean insertButtonEnabled) {
        this.insertButtonEnabled = insertButtonEnabled;
    }

    protected abstract C getFromValue(T var1);

    @NotNull
    public Function<SELF, C> getCreateNewInstance() {
        return this.createNewInstance;
    }

    public void setCreateNewInstance(@NotNull Function<SELF, C> createNewInstance) {
        this.createNewInstance = createNewInstance;
    }

    @Nullable
    public Component getAddTooltip() {
        return this.addTooltip;
    }

    public void setAddTooltip(@Nullable Component addTooltip) {
        this.addTooltip = addTooltip;
    }

    @Nullable
    public Component getRemoveTooltip() {
        return this.removeTooltip;
    }

    public void setRemoveTooltip(@Nullable Component removeTooltip) {
        this.removeTooltip = removeTooltip;
    }

    @Override
    public Optional<List<T>> getDefaultValue() {
        if (this.defaultValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public int getItemHeight() {
        if (this.isExpanded()) {
            int i = 24;
            for (BaseListCell entry : this.cells) {
                i += entry.getCellHeight();
            }
            return i;
        }
        return 24;
    }

    public List<? extends GuiEventListener> m_6702_() {
        if (!this.isExpanded()) {
            ArrayList<GuiEventListener> elements = new ArrayList<GuiEventListener>(this.widgets);
            elements.removeAll(this.cells);
            return elements;
        }
        return this.widgets;
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return this.narratables;
    }

    @Override
    public Optional<Component> getError() {
        List errors = this.cells.stream().map(BaseListCell::getConfigError).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (errors.size() > 1) {
            return Optional.of(Component.m_237115_((String)"text.cloth-config.multi_error"));
        }
        return errors.stream().findFirst();
    }

    @Override
    public void save() {
        for (BaseListCell cell : this.cells) {
            if (!(cell instanceof ReferenceProvider)) continue;
            ((ReferenceProvider)((Object)cell)).provideReferenceEntry().save();
        }
        super.save();
    }

    @Override
    public Rectangle getEntryArea(int x, int y, int entryWidth, int entryHeight) {
        this.labelWidget.rectangle.x = x - 15;
        this.labelWidget.rectangle.y = y;
        this.labelWidget.rectangle.width = entryWidth + 15;
        this.labelWidget.rectangle.height = 24;
        return new Rectangle(this.getParent().left, y, this.getParent().right - this.getParent().left, 20);
    }

    protected boolean isInsideCreateNew(double mouseX, double mouseY) {
        return this.isInsertButtonEnabled() && mouseX >= (double)(this.labelWidget.rectangle.x + 12) && mouseY >= (double)(this.labelWidget.rectangle.y + 3) && mouseX <= (double)(this.labelWidget.rectangle.x + 12 + 11) && mouseY <= (double)(this.labelWidget.rectangle.y + 3 + 11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isInsideDelete(double mouseX, double mouseY) {
        if (!this.isDeleteButtonEnabled()) return false;
        int n = this.labelWidget.rectangle.x;
        int n2 = this.isInsertButtonEnabled() ? 25 : 12;
        if (!(mouseX >= (double)(n + n2))) return false;
        if (!(mouseY >= (double)(this.labelWidget.rectangle.y + 3))) return false;
        int n3 = this.labelWidget.rectangle.x;
        int n4 = this.isInsertButtonEnabled() ? 25 : 12;
        if (!(mouseX <= (double)(n3 + n4 + 11))) return false;
        if (!(mouseY <= (double)(this.labelWidget.rectangle.y + 3 + 11))) return false;
        return true;
    }

    @Override
    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.addTooltip != null && this.isInsideCreateNew(mouseX, mouseY)) {
            return Optional.of(new Component[]{this.addTooltip});
        }
        if (this.removeTooltip != null && this.isInsideDelete(mouseX, mouseY)) {
            return Optional.of(new Component[]{this.removeTooltip});
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONFIG_TEX);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BaseListCell focused = !this.isExpanded() || this.m_7222_() == null || !(this.m_7222_() instanceof BaseListCell) ? null : (BaseListCell)this.m_7222_();
        boolean insideLabel = this.labelWidget.rectangle.contains(mouseX, mouseY);
        boolean insideCreateNew = this.isInsideCreateNew(mouseX, mouseY);
        boolean insideDelete = this.isInsideDelete(mouseX, mouseY);
        graphics.m_280218_(CONFIG_TEX, x - 15, y + 5, 33, (this.isEnabled() ? (insideLabel && !insideCreateNew && !insideDelete ? 18 : 0) : 36) + (this.isExpanded() ? 9 : 0), 9, 9);
        if (this.isInsertButtonEnabled()) {
            graphics.m_280218_(CONFIG_TEX, x - 15 + 13, y + 5, 42, insideCreateNew ? 9 : 0, 9, 9);
        }
        if (this.isDeleteButtonEnabled()) {
            graphics.m_280218_(CONFIG_TEX, x - 15 + (this.isInsertButtonEnabled() ? 26 : 13), y + 5, 51, focused == null ? 0 : (insideDelete ? 18 : 9), 9, 9);
        }
        this.resetWidget.m_252865_(x + entryWidth - this.resetWidget.m_5711_());
        this.resetWidget.m_253211_(y);
        this.resetWidget.f_93623_ = this.isEditable() && this.getDefaultValue().isPresent() && !this.isMatchDefault();
        this.resetWidget.m_88315_(graphics, mouseX, mouseY, delta);
        int offset = (this.isInsertButtonEnabled() || this.isDeleteButtonEnabled() ? 6 : 0) + (this.isInsertButtonEnabled() ? 9 : 0) + (this.isDeleteButtonEnabled() ? 9 : 0);
        graphics.m_280648_(Minecraft.m_91087_().f_91062_, this.getDisplayedFieldName().m_7532_(), x + offset, y + 6, insideLabel && !this.resetWidget.m_5953_((double)mouseX, (double)mouseY) && !insideDelete && !insideCreateNew ? -1638890 : this.getPreferredTextColor());
        if (this.isExpanded()) {
            int yy = y + 24;
            for (BaseListCell cell : this.cells) {
                cell.render(graphics, -1, yy, x + 14, entryWidth - 14, cell.getCellHeight(), mouseX, mouseY, this.getParent().getFocused() != null && ((AbstractConfigEntry)this.getParent().getFocused()).equals(this) && this.m_7222_() != null && this.m_7222_().equals((Object)cell), delta);
                yy += cell.getCellHeight();
            }
        }
    }

    @Override
    public void updateSelected(boolean isSelected) {
        for (BaseListCell cell : this.cells) {
            cell.updateSelected(isSelected && this.m_7222_() == cell && this.isExpanded());
        }
    }

    @Override
    public int getInitialReferenceOffset() {
        return 24;
    }

    public boolean insertInFront() {
        return this.insertInFront;
    }

    public class ListLabelWidget
    implements GuiEventListener {
        protected Rectangle rectangle = new Rectangle();

        public boolean m_6375_(double mouseX, double mouseY, int int_1) {
            if (!BaseListEntry.this.isEnabled()) {
                return false;
            }
            if (BaseListEntry.this.resetWidget.m_5953_(mouseX, mouseY)) {
                return false;
            }
            if (BaseListEntry.this.isInsideCreateNew(mouseX, mouseY)) {
                BaseListCell cell;
                BaseListEntry.this.setExpanded(true);
                if (BaseListEntry.this.insertInFront()) {
                    cell = (BaseListCell)((Object)BaseListEntry.this.createNewInstance.apply(BaseListEntry.this.self()));
                    BaseListEntry.this.cells.add(0, cell);
                    BaseListEntry.this.widgets.add(0, (GuiEventListener)cell);
                } else {
                    cell = (BaseListCell)((Object)BaseListEntry.this.createNewInstance.apply(BaseListEntry.this.self()));
                    BaseListEntry.this.cells.add(cell);
                    BaseListEntry.this.widgets.add((GuiEventListener)cell);
                }
                cell.onAdd();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            if (BaseListEntry.this.isDeleteButtonEnabled() && BaseListEntry.this.isInsideDelete(mouseX, mouseY)) {
                GuiEventListener focused = BaseListEntry.this.m_7222_();
                if (BaseListEntry.this.isExpanded() && focused instanceof BaseListCell) {
                    ((BaseListCell)focused).onDelete();
                    BaseListEntry.this.cells.remove(focused);
                    BaseListEntry.this.widgets.remove(focused);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                }
                return true;
            }
            if (this.rectangle.contains(mouseX, mouseY)) {
                BaseListEntry.this.setExpanded(!BaseListEntry.this.expanded);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            return false;
        }

        public void m_93692_(boolean bl) {
        }

        public boolean m_93696_() {
            return false;
        }
    }
}

