/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.profiling;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.chiselsandbits.api.profiling.IProfilerResult;
import net.minecraft.util.profiling.FilledProfileResults;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ResultField;

public class CandBProfilingResult
implements IProfilerResult {
    private final ProfileResults innerResult;

    public CandBProfilingResult(ProfileResults innerResult) {
        this.innerResult = innerResult;
    }

    @Override
    public void writeToFile(Path file) {
        this.innerResult.m_142444_(file);
    }

    @Override
    public void writeAsResponse(Consumer<String> lineConsumer) {
        ProfileResults profileResults = this.innerResult;
        if (!(profileResults instanceof FilledProfileResults)) {
            return;
        }
        FilledProfileResults filledProfileResult = (FilledProfileResults)profileResults;
        lineConsumer.accept("Results:");
        this.writeDatapointsAsResponse("root", arg_0 -> ((FilledProfileResults)filledProfileResult).m_6412_(arg_0), lineConsumer, " ");
    }

    private void writeDatapointsAsResponse(String name, Function<String, List<ResultField>> producer, Consumer<String> lineConsumer, String indent) {
        List<ResultField> dataPoints = producer.apply(name);
        dataPoints.forEach(dataPoint -> {
            lineConsumer.accept(String.format("%s> %s: %s (%s)", indent, dataPoint.f_18610_.substring(dataPoint.f_18610_.lastIndexOf(30) + 1), dataPoint.f_18607_, dataPoint.f_18608_));
            if (!dataPoint.f_18610_.equals(name)) {
                this.writeDatapointsAsResponse(name + "\u001e" + dataPoint.f_18610_, producer, lineConsumer, indent + " ");
            }
        });
    }
}

