/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face;

import com.communi.suggestu.scena.core.client.fluid.IClientFluidManager;
import com.communi.suggestu.scena.core.client.models.baked.IDataAwareBakedModel;
import com.communi.suggestu.scena.core.client.rendering.IRenderingManager;
import com.communi.suggestu.scena.core.fluid.FluidInformation;
import com.communi.suggestu.scena.core.registries.IPlatformRegistryManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.client.color.IBlockInformationColorManager;
import mod.chiselsandbits.api.client.variant.state.IClientStateVariantManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.client.model.baked.face.model.ModelVertexRange;
import mod.chiselsandbits.client.model.baked.simple.SimpleGeneratedModel;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.LightUtil;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class FaceManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final RandomSource RANDOM = RandomSource.m_216335_((long)42L);
    private static final FaceManager INSTANCE = new FaceManager();
    private final SimpleMaxSizedCache<Key, Collection<ModelQuadLayer>> cache = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getFaceLayerCacheSize())::get);
    private final SimpleMaxSizedCache<IBlockInformation, Integer> colorCache = new SimpleMaxSizedCache(() -> IPlatformRegistryManager.getInstance().getBlockStateIdMap().m_13562_() == 0 ? 1000 : IPlatformRegistryManager.getInstance().getBlockStateIdMap().m_13562_());

    private FaceManager() {
    }

    public static FaceManager getInstance() {
        return INSTANCE;
    }

    private static Optional<ModelQuadLayer> createQuadLayer(BakedQuad quad, IBlockInformation blockInformation, Direction cullDirection, int stateColor) {
        if (quad.m_111306_() != cullDirection) {
            return Optional.empty();
        }
        try {
            TextureAtlasSprite sprite = FaceManager.findQuadTexture(quad);
            ModelQuadLayer.Builder layerBuilder = ModelQuadLayer.Builder.create(blockInformation);
            layerBuilder.setTexture(sprite);
            layerBuilder.withColor(stateColor);
            layerBuilder.withSourceQuad(quad);
            LightUtil.put(layerBuilder, quad);
            return Optional.of(layerBuilder.build());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to process quad: " + quad, (Throwable)ex);
            return Optional.empty();
        }
    }

    private static BakedModel solveModel(IBlockInformation state, BakedModel originalModel, long primaryStateRenderSeed, RenderType renderType) {
        ItemStack is;
        boolean hasFaces;
        try {
            hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed, renderType);
            for (Direction f : Direction.values()) {
                hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed, renderType);
            }
        }
        catch (Exception e) {
            hasFaces = false;
        }
        if (!hasFaces && !(is = ItemStackUtils.getItemStackFromBlockState(state)).m_41619_()) {
            BakedModel itemModel = Minecraft.m_91087_().m_91291_().m_174264_(is, (Level)Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
            try {
                hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed, renderType);
                for (Direction f : Direction.values()) {
                    hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed, renderType);
                }
            }
            catch (Exception e) {
                hasFaces = false;
            }
            if (hasFaces) {
                return itemModel;
            }
            return new SimpleGeneratedModel(FaceManager.findTexture(state, originalModel, Direction.UP, primaryStateRenderSeed, renderType));
        }
        return originalModel;
    }

    private static boolean hasFaces(BakedModel model, IBlockInformation state, Direction f, long primaryStateRenderSeed, RenderType renderType) {
        List<BakedQuad> quads = FaceManager.getModelQuads(model, state, f, primaryStateRenderSeed, renderType);
        if (quads == null || quads.isEmpty()) {
            return false;
        }
        TextureAtlasSprite texture = null;
        try {
            texture = FaceManager.findTexture(null, quads, f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModelVertexRange vertexRangeExtractor = new ModelVertexRange();
        for (BakedQuad quad : quads) {
            LightUtil.put(vertexRangeExtractor, quad);
        }
        return vertexRangeExtractor.getLargestRange() > 0.0f && !FaceManager.isMissingTexture(texture);
    }

    public static TextureAtlasSprite findTexture(IBlockInformation state, BakedModel model, Direction myFace, long primaryStateRenderSeed, RenderType renderType) {
        TextureAtlasSprite texture = null;
        if (model != null) {
            try {
                texture = FaceManager.findTexture(null, FaceManager.getModelQuads(model, state, myFace, primaryStateRenderSeed, renderType), myFace);
                if (texture == null) {
                    for (Direction side : Direction.values()) {
                        texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, side, primaryStateRenderSeed, renderType), side);
                    }
                    texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, null, primaryStateRenderSeed, renderType), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                if (model != null) {
                    texture = model.m_6160_();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                texture = Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state.getBlockState());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("missingno"));
        }
        return texture;
    }

    private static TextureAtlasSprite findTexture(TextureAtlasSprite texture, List<BakedQuad> faceQuads, Direction myFace) throws IllegalArgumentException, NullPointerException {
        for (BakedQuad q : faceQuads) {
            if (q.m_111306_() != myFace) continue;
            texture = FaceManager.findQuadTexture(q);
        }
        return texture;
    }

    private static TextureAtlasSprite findQuadTexture(BakedQuad q) throws IllegalArgumentException, NullPointerException {
        if (q.m_173410_() == null) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
        }
        return q.m_173410_();
    }

    private static boolean isMissingTexture(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return true;
        }
        return sprite.m_245424_().m_246162_().equals((Object)MissingTextureAtlasSprite.m_118071_());
    }

    private static List<BakedQuad> getModelQuads(BakedModel model, IBlockInformation state, Direction f, long primaryStateRenderSeed, RenderType renderType) {
        RANDOM.m_188584_(primaryStateRenderSeed);
        try {
            if (model instanceof IDataAwareBakedModel) {
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)model;
                return dataAwareBakedModel.getQuads(state.getBlockState(), f, RANDOM, IClientStateVariantManager.getInstance().getBlockModelData(state), renderType);
            }
            return model.m_213637_(state.getBlockState(), f, RANDOM);
        }
        catch (Throwable dataAwareBakedModel) {
            try {
                if (model instanceof IDataAwareBakedModel) {
                    IDataAwareBakedModel dataAwareBakedModel2 = (IDataAwareBakedModel)model;
                    return dataAwareBakedModel2.getQuads(null, f, RANDOM, IClientStateVariantManager.getInstance().getBlockModelData(state), renderType);
                }
                return model.m_213637_(null, f, RANDOM);
            }
            catch (Throwable dataAwareBakedModel2) {
                BakedModel secondModel;
                ItemStack is = ItemStackUtils.getItemStackFromBlockState(state);
                if (!is.m_41619_() && (secondModel = FaceManager.getOverrides(model).m_173464_(model, is, Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 0)) != null) {
                    try {
                        if (secondModel instanceof IDataAwareBakedModel) {
                            IDataAwareBakedModel dataAwareBakedModel3 = (IDataAwareBakedModel)secondModel;
                            return dataAwareBakedModel3.getQuads(state.getBlockState(), f, RANDOM, IClientStateVariantManager.getInstance().getBlockModelData(state), renderType);
                        }
                        return secondModel.m_213637_(state.getBlockState(), f, RANDOM);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return Collections.emptyList();
            }
        }
    }

    private static ItemOverrides getOverrides(BakedModel model) {
        if (model != null) {
            return model.m_7343_();
        }
        return ItemOverrides.f_111734_;
    }

    private static void injectFluidVertexDataForSide(ModelQuadLayer.Builder builder, float minU, float maxU, float minV, float maxV, Direction cullDirection) {
        if (cullDirection == null) {
            return;
        }
        switch (cullDirection) {
            case DOWN: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(0.0f).withY(0.0f).withZ(1.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(0.0f).withY(0.0f).withZ(0.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(1.0f).withY(0.0f).withZ(1.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(1.0f).withY(0.0f).withZ(0.0f).withU(maxU).withV(minV));
                break;
            }
            case UP: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(0.0f).withY(1.0f).withZ(0.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(0.0f).withY(1.0f).withZ(1.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(1.0f).withY(1.0f).withZ(1.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(1.0f).withY(1.0f).withZ(0.0f).withU(maxU).withV(minV));
                break;
            }
            case NORTH: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(1.0f).withY(1.0f).withZ(0.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(1.0f).withY(0.0f).withZ(0.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(0.0f).withY(0.0f).withZ(0.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(0.0f).withY(1.0f).withZ(0.0f).withU(maxU).withV(minV));
                break;
            }
            case SOUTH: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(0.0f).withY(1.0f).withZ(1.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(0.0f).withY(0.0f).withZ(1.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(1.0f).withY(0.0f).withZ(1.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(1.0f).withY(1.0f).withZ(1.0f).withU(maxU).withV(minV));
                break;
            }
            case WEST: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(0.0f).withY(1.0f).withZ(0.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(0.0f).withY(0.0f).withZ(0.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(0.0f).withY(0.0f).withZ(1.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(0.0f).withY(1.0f).withZ(1.0f).withU(maxU).withV(minV));
                break;
            }
            case EAST: {
                builder.withVertexData(v -> v.withVertexIndex(0).withX(1.0f).withY(1.0f).withZ(1.0f).withU(minU).withV(minV));
                builder.withVertexData(v -> v.withVertexIndex(1).withX(1.0f).withY(0.0f).withZ(1.0f).withU(minU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(2).withX(1.0f).withY(0.0f).withZ(0.0f).withU(maxU).withV(maxV));
                builder.withVertexData(v -> v.withVertexIndex(3).withX(1.0f).withY(1.0f).withZ(0.0f).withU(maxU).withV(minV));
            }
        }
    }

    public void clearCache() {
        this.cache.clear();
        this.colorCache.clear();
    }

    public Collection<ModelQuadLayer> getCachedLayersFor(IBlockInformation state, Direction face, RenderType layer, long primaryStateRenderSeed, @NotNull RenderType renderType) {
        if (layer == null) {
            return null;
        }
        Key key = new Key(state, layer, face, primaryStateRenderSeed, renderType);
        return this.cache.get(key, () -> this.buildFaceQuadLayers(state, face, primaryStateRenderSeed, renderType));
    }

    private List<ModelQuadLayer> buildFaceQuadLayers(IBlockInformation blockInformation, Direction cullDirection, long primaryStateRenderSeed, @NotNull RenderType renderType) {
        BakedModel model = FaceManager.solveModel(blockInformation, Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(blockInformation.getBlockState()), primaryStateRenderSeed, renderType);
        int lv = IClientConfiguration.getInstance().getUseGetLightValue().get() != false ? blockInformation.getBlockState().m_60791_() : 0;
        Fluid fluid = blockInformation.getBlockState().m_60819_().m_76152_();
        if (fluid != Fluids.f_76191_) {
            ModelQuadLayer.Builder builder = ModelQuadLayer.Builder.create(blockInformation);
            builder.setQuadOrientation(cullDirection);
            builder.withColor(IClientFluidManager.getInstance().getFluidColor(new FluidInformation(fluid)));
            builder.withLight(lv);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IRenderingManager.getInstance().getFlowingFluidTexture(fluid));
            if (cullDirection.m_122434_() == Direction.Axis.Y) {
                sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IRenderingManager.getInstance().getStillFluidTexture(fluid));
            }
            float minV = sprite.m_118411_();
            float maxU = sprite.m_118367_((double)(256.0f / (float)sprite.m_245424_().m_246492_()));
            float minU = sprite.m_118409_();
            float maxV = sprite.m_118393_((double)(256.0f / (float)sprite.m_245424_().m_245330_()));
            builder.withSprite(sprite);
            FaceManager.injectFluidVertexDataForSide(builder, minU, maxU, minV, maxV, cullDirection);
            builder.setQuadTint(255);
            return Collections.singletonList(builder.build());
        }
        ArrayList layers = Lists.newArrayList();
        int color = this.getColorFor(blockInformation);
        if (model != null) {
            List<BakedQuad> quads = FaceManager.getModelQuads(model, blockInformation, cullDirection, primaryStateRenderSeed, renderType);
            quads.forEach(quad -> FaceManager.createQuadLayer(quad, blockInformation, cullDirection, color).ifPresent(layers::add));
        }
        return layers;
    }

    private int getColorFor(IBlockInformation state) {
        return this.colorCache.get(state, () -> {
            ItemStack target;
            Optional<Integer> dynamicColor = IBlockInformationColorManager.getInstance().getColor(state);
            if (dynamicColor.isPresent()) {
                return dynamicColor.get();
            }
            Fluid fluid = state.getBlockState().m_60819_().m_76152_();
            int out = fluid != Fluids.f_76191_ ? IClientFluidManager.getInstance().getFluidColor(fluid) : ((target = ItemStackUtils.getItemStackFromBlockState(state)).m_41619_() ? 0xFFFFFF : Minecraft.m_91087_().f_91041_.m_92676_(target, 0));
            return out;
        });
    }

    private record Key(IBlockInformation blockState, RenderType renderType, Direction direction, long primaryStateSeed, RenderType type) {
    }
}

