/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.mixin;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.events.EventBus;
import com.ebicep.chatplus.features.chattabs.AddNewMessageEvent;
import com.ebicep.chatplus.features.chattabs.ChatTab;
import com.ebicep.chatplus.features.chattabs.SkipNewMessageEvent;
import com.ebicep.chatplus.features.chatwindows.ChatWindowsManager;
import com.ebicep.chatplus.hud.ChatManager;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.ArrayList;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MessageSignature;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class}, priority=0x7FFFFFFF)
public class MixinChatComponent {
    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, int k, CallbackInfo ci) {
        if (!ChatPlus.INSTANCE.isEnabled() || Config.INSTANCE.getValues().getShowVanillaWhenUnfocused() && !ChatManager.INSTANCE.isChatFocused()) {
            return;
        }
        ChatWindowsManager.INSTANCE.renderAll(guiGraphics, i, j, k);
        ci.cancel();
    }

    @ModifyArg(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ComponentRenderUtils;wrapComponents(Lnet/minecraft/network/chat/FormattedText;ILnet/minecraft/client/gui/Font;)Ljava/util/List;"), index=0)
    private FormattedText components(FormattedText arg3, @Share(value="chatplus$component") LocalRef<Component> component) {
        if (arg3 instanceof Component) {
            Component c = (Component)arg3;
            component.set((Object)c);
        }
        return arg3;
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at={@At(value="RETURN")})
    public void addMessage(Component component, MessageSignature messageSignature, int i, GuiMessageTag guiMessageTag, boolean bl, CallbackInfo ci, @Share(value="chatplus$component") LocalRef<Component> c) {
        if (!ChatPlus.INSTANCE.isEnabled() && !Config.INSTANCE.getValues().getAddMessagesIfDisabled()) {
            return;
        }
        component = (Component)c.get();
        ArrayList<ChatTab> addMessagesTo = new ArrayList<ChatTab>();
        Integer lastPriority = null;
        for (ChatTab chatTab : ChatManager.INSTANCE.getGlobalSortedTabs()) {
            int priority = chatTab.getPriority();
            boolean alwaysAdd = chatTab.getAlwaysAdd();
            if (lastPriority != null && lastPriority > priority && !alwaysAdd || !chatTab.matches(component.getString())) continue;
            addMessagesTo.add(chatTab);
            if (chatTab.getSkipOthers()) break;
            if (alwaysAdd) continue;
            lastPriority = priority;
        }
        if (!addMessagesTo.isEmpty()) {
            messageEvent = new AddNewMessageEvent(component.m_6881_(), component, null, messageSignature, i, guiMessageTag, false);
            EventBus.INSTANCE.post(AddNewMessageEvent.class, messageEvent);
            if (((AddNewMessageEvent)messageEvent).getReturnFunction()) {
                return;
            }
            for (ChatTab chatTab : addMessagesTo) {
                chatTab.addNewMessage((AddNewMessageEvent)messageEvent);
            }
        } else {
            messageEvent = new SkipNewMessageEvent(component.m_6881_(), component, null, messageSignature, i, guiMessageTag);
            EventBus.INSTANCE.post(SkipNewMessageEvent.class, messageEvent);
        }
    }
}

