/*
 * Decompiled with CFR 0.152.
 */
package nuparu.caelum.client.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import nuparu.caelum.Caelum;
import nuparu.caelum.config.ClientConfig;

public class StarDataManager
extends SimpleJsonResourceReloadListener {
    public static VertexBuffer vanillaStarBuffer = null;
    private static final Gson GSON = new GsonBuilder().create();
    public static final StarDataManager INSTANCE = new StarDataManager();
    @Nullable
    private VertexBuffer starBuffer;

    public StarDataManager() {
        super(GSON, "stars");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ArrayList<StellarData> stars = new ArrayList<StellarData>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            DataResult dataResult = StellarDataList.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue());
            dataResult.get().ifLeft(stellarDataList -> {
                if (stellarDataList.replace()) {
                    stars.clear();
                }
                stars.addAll(stellarDataList.stars());
            }).ifRight(p_248506_ -> Caelum.LOGGER.warn("Failed to read stellar data {}", (Object)p_248506_.message()));
        }
        this.createStars(stars);
    }

    private void createStars(List<StellarData> stars) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.drawStars(bufferbuilder, stars);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer drawStars(BufferBuilder bufferBuilder, List<StellarData> stars) {
        RandomSource randomSource = RandomSource.m_216335_((long)10842L);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        double maxMagnitude = stars.stream().mapToDouble(StellarData::magnitude).max().orElse(1.0);
        double minMagnitude = stars.stream().mapToDouble(StellarData::magnitude).min().orElse(0.0);
        double shift = Math.abs(minMagnitude);
        double logMinMagnitude = 0.0;
        double logMaxMagnitude = Math.log10(maxMagnitude += shift);
        for (StellarData star : stars) {
            double magnitude = star.magnitude();
            if (magnitude > (Double)ClientConfig.maxMagnitude.get()) continue;
            double d0 = Math.cos(star.declination()) * Math.cos(star.ascension());
            double d1 = Math.cos(star.declination()) * Math.sin(star.ascension());
            double d2 = Math.sin(star.declination());
            double logMagnitude = Math.log10(magnitude + shift);
            double normalizedMagnitude = (logMagnitude - logMinMagnitude) / (logMaxMagnitude - logMinMagnitude);
            double size = (0.6 - normalizedMagnitude * 0.5) * (Double)ClientConfig.starSize.get();
            if (size <= 0.0) continue;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomSource.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            int red = Integer.parseInt(star.color().substring(0, 2), 16);
            int green = Integer.parseInt(star.color().substring(2, 4), 16);
            int blue = Integer.parseInt(star.color().substring(4, 6), 16);
            if (!((Boolean)ClientConfig.starColors.get()).booleanValue()) {
                red = 255;
                green = 255;
                blue = 255;
            }
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * size;
                double d19 = (double)((j + 1 & 2) - 1) * size;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_6122_(red, green, blue, (int)((1.0 - normalizedMagnitude) * 255.0)).m_5752_();
            }
        }
        return bufferBuilder.m_231175_();
    }

    public VertexBuffer getStarBuffer() {
        return this.starBuffer;
    }

    private record StellarDataList(boolean replace, List<StellarData> stars) {
        public static final Codec<StellarDataList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(StellarDataList::replace), (App)StellarData.CODEC.listOf().fieldOf("stars").forGetter(StellarDataList::stars)).apply((Applicative)instance, StellarDataList::new));
    }

    private record StellarData(String name, double ascension, double declination, double magnitude, String color) {
        public static final Codec<StellarData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(StellarData::name), (App)Codec.DOUBLE.fieldOf("ascension").forGetter(StellarData::ascension), (App)Codec.DOUBLE.fieldOf("declination").forGetter(StellarData::declination), (App)Codec.DOUBLE.fieldOf("magnitude").forGetter(StellarData::magnitude), (App)Codec.STRING.optionalFieldOf("color", (Object)"#ffffff").forGetter(StellarData::color)).apply((Applicative)instance, StellarData::new));
    }
}

