/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings.screen;

import net.bojarsky.bojarskythings.block.ModBlocks;
import net.bojarsky.bojarskythings.blockentity.ModGrindstoneBlockEntity;
import net.bojarsky.bojarskythings.items.ModItems;
import net.bojarsky.bojarskythings.screen.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ModGrindstoneMenu
extends AbstractContainerMenu {
    private final ModGrindstoneBlockEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 1;

    public ModGrindstoneMenu(int windowId, Inventory playerInventory, ModGrindstoneBlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.MOD_GRINDSTONE_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.level = playerInventory.f_35978_.m_9236_();
        ModGrindstoneMenu.m_38869_((Container)playerInventory, (int)1);
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.addBlockEntityInventory();
    }

    public ModGrindstoneMenu(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, ModGrindstoneMenu.getBlockEntity(playerInventory, extraData));
    }

    private static ModGrindstoneBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        if (playerInventory == null || data == null) {
            throw new IllegalArgumentException("Player Inventory or Extra Data cannot be null!");
        }
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (blockEntity instanceof ModGrindstoneBlockEntity) {
            return (ModGrindstoneBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + blockEntity);
    }

    private void addBlockEntityInventory() {
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 80, 35, (IItemHandler)handler){
            final /* synthetic */ IItemHandler val$handler;
            {
                this.val$handler = iItemHandler;
                super(arg0, arg1, arg2, arg3);
            }

            public boolean m_5857_(@NotNull ItemStack stack) {
                Item item = stack.m_41720_();
                return item == ModItems.SHARPENING_STONE_1.get() || item == ModItems.SHARPENING_STONE_2.get() || item == ModItems.SHARPENING_STONE_3.get();
            }

            public int m_6641_() {
                return this.val$handler.getSlotLimit(0);
            }
        }));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index >= 0 && index < 36) {
            boolean isSharpeningStone;
            Item sourceItem = sourceStack.m_41720_();
            boolean bl = isSharpeningStone = sourceItem == ModItems.SHARPENING_STONE_1.get() || sourceItem == ModItems.SHARPENING_STONE_2.get() || sourceItem == ModItems.SHARPENING_STONE_3.get();
            if (isSharpeningStone ? !this.m_38903_(sourceStack, 36, 37, false) : (index < 36 && index >= 9 ? !this.m_38903_(sourceStack, 0, 9, false) : index < 9 && !this.m_38903_(sourceStack, 9, 36, false))) {
                return ItemStack.f_41583_;
            }
        } else if (index >= 36 && index < 37) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.err.println("Invalid slot index: " + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41619_()) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        if (sourceStack.m_41613_() == copyOfSourceStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return ModGrindstoneMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.MOD_GRINDSTONE.get()));
    }
}

