/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings.entity.custom;

import java.util.List;
import net.bojarsky.bojarskythings.config.MobConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BanditEntity
extends Monster {
    public BanditEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected ResourceLocation m_7582_() {
        return new ResourceLocation("bojarskythings", "entities/bandit");
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, ((Double)MobConfig.SERVER.bandit.GOAL_MELEE_ATTACK_SPEED_MODIFIER.get()).doubleValue(), false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, ((Double)MobConfig.SERVER.bandit.GOAL_LOOK_AT_PLAYER_DISTANCE.get()).floatValue()));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, ((Double)MobConfig.SERVER.bandit.GOAL_WATER_AVOIDING_STROLL_SPEED_MODIFIER.get()).doubleValue()));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 15.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    private void applyConfigurableAttributes() {
        if (!this.m_9236_().f_46443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)MobConfig.SERVER.bandit.MAX_HEALTH.get()).doubleValue());
            this.m_21051_(Attributes.f_22279_).m_22100_(((Double)MobConfig.SERVER.bandit.MOVEMENT_SPEED.get()).doubleValue());
            this.m_21051_(Attributes.f_22281_).m_22100_(((Double)MobConfig.SERVER.bandit.ATTACK_DAMAGE.get()).doubleValue());
            this.m_21051_(Attributes.f_22277_).m_22100_(((Double)MobConfig.SERVER.bandit.FOLLOW_RANGE.get()).doubleValue());
            this.m_21051_(Attributes.f_22284_).m_22100_(((Double)MobConfig.SERVER.bandit.ARMOR_VALUE.get()).doubleValue());
            this.m_21051_(Attributes.f_22278_).m_22100_(((Double)MobConfig.SERVER.bandit.KNOCKBACK_RESISTANCE.get()).doubleValue());
            this.m_21153_(this.m_21233_());
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        String offhandItemId;
        Item offhandItem;
        List feetItems;
        List legsItems;
        List chestItems;
        List headItems;
        spawnData = super.m_6518_(levelAccessor, difficulty, reason, spawnData, dataTag);
        this.applyConfigurableAttributes();
        RandomSource random = levelAccessor.m_213780_();
        List mainhandItems = (List)MobConfig.SERVER.bandit.EQUIP_MAINHAND_ITEMS.get();
        if (!mainhandItems.isEmpty() && random.m_188501_() < ((Double)MobConfig.SERVER.bandit.EQUIP_MAINHAND_CHANCE.get()).floatValue()) {
            String weaponId = (String)mainhandItems.get(random.m_188503_(mainhandItems.size()));
            this.setDamagedEquipment(random, EquipmentSlot.MAINHAND, weaponId, ((Double)MobConfig.SERVER.bandit.EQUIP_MAINHAND_DAMAGE_MIN.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_MAINHAND_DAMAGE_MAX.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_MAINHAND_DROP_CHANCE.get()).floatValue());
        }
        if (!(headItems = (List)MobConfig.SERVER.bandit.EQUIP_HEAD_ITEMS.get()).isEmpty() && random.m_188501_() < ((Double)MobConfig.SERVER.bandit.EQUIP_HEAD_CHANCE.get()).floatValue()) {
            String helmetId = (String)headItems.get(random.m_188503_(headItems.size()));
            this.setDamagedEquipment(random, EquipmentSlot.HEAD, helmetId, ((Double)MobConfig.SERVER.bandit.EQUIP_HEAD_DAMAGE_MIN.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_HEAD_DAMAGE_MAX.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_HEAD_DROP_CHANCE.get()).floatValue());
        }
        if (!(chestItems = (List)MobConfig.SERVER.bandit.EQUIP_CHEST_ITEMS.get()).isEmpty() && random.m_188501_() < ((Double)MobConfig.SERVER.bandit.EQUIP_CHEST_CHANCE.get()).floatValue()) {
            String chestplateId = (String)chestItems.get(random.m_188503_(chestItems.size()));
            this.setDamagedEquipment(random, EquipmentSlot.CHEST, chestplateId, ((Double)MobConfig.SERVER.bandit.EQUIP_CHEST_DAMAGE_MIN.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_CHEST_DAMAGE_MAX.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_CHEST_DROP_CHANCE.get()).floatValue());
        }
        if (!(legsItems = (List)MobConfig.SERVER.bandit.EQUIP_LEGS_ITEMS.get()).isEmpty() && random.m_188501_() < ((Double)MobConfig.SERVER.bandit.EQUIP_LEGS_CHANCE.get()).floatValue()) {
            String leggingsId = (String)legsItems.get(random.m_188503_(legsItems.size()));
            this.setDamagedEquipment(random, EquipmentSlot.LEGS, leggingsId, ((Double)MobConfig.SERVER.bandit.EQUIP_LEGS_DAMAGE_MIN.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_LEGS_DAMAGE_MAX.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_LEGS_DROP_CHANCE.get()).floatValue());
        }
        if (!(feetItems = (List)MobConfig.SERVER.bandit.EQUIP_FEET_ITEMS.get()).isEmpty() && random.m_188501_() < ((Double)MobConfig.SERVER.bandit.EQUIP_FEET_CHANCE.get()).floatValue()) {
            String bootsId = (String)feetItems.get(random.m_188503_(feetItems.size()));
            this.setDamagedEquipment(random, EquipmentSlot.FEET, bootsId, ((Double)MobConfig.SERVER.bandit.EQUIP_FEET_DAMAGE_MIN.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_FEET_DAMAGE_MAX.get()).floatValue(), ((Double)MobConfig.SERVER.bandit.EQUIP_FEET_DROP_CHANCE.get()).floatValue());
        }
        if (((Boolean)MobConfig.SERVER.bandit.EQUIP_OFFHAND_CONDITION_IS_NIGHT.get()).booleanValue() && this.m_9236_().m_46462_() && (offhandItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(offhandItemId = (String)MobConfig.SERVER.bandit.EQUIP_OFFHAND_ITEM.get()))) != null && offhandItem != Items.f_41852_) {
            ItemStack offhandStack = new ItemStack((ItemLike)offhandItem);
            this.m_8061_(EquipmentSlot.OFFHAND, offhandStack);
            this.m_21409_(EquipmentSlot.OFFHAND, ((Double)MobConfig.SERVER.bandit.EQUIP_OFFHAND_DROP_CHANCE.get()).floatValue());
        }
        return spawnData;
    }

    private void setDamagedEquipment(RandomSource random, EquipmentSlot slot, String itemId, float minDurabilityPercent, float maxDurabilityPercent, float dropChance) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item != null && item != Items.f_41852_) {
            ItemStack itemStack = new ItemStack((ItemLike)item);
            this.setLowDurability(random, itemStack, minDurabilityPercent, maxDurabilityPercent);
            this.m_8061_(slot, itemStack);
            this.m_21409_(slot, dropChance);
        }
    }

    private void setLowDurability(RandomSource random, ItemStack itemStack, float minDurabilityPercent, float maxDurabilityPercent) {
        if (!itemStack.m_41763_()) {
            return;
        }
        int maxDamage = itemStack.m_41776_();
        if (maxDamage > 0) {
            float actualMax;
            float actualMin = Math.min(minDurabilityPercent, maxDurabilityPercent);
            if (actualMin == (actualMax = Math.max(minDurabilityPercent, maxDurabilityPercent)) && actualMax < 1.0f) {
                actualMax = Math.min(1.0f, actualMin + 0.01f);
            } else if (actualMin == actualMax && actualMax >= 1.0f) {
                return;
            }
            float durabilityPercent = actualMin + random.m_188501_() * (actualMax - actualMin);
            int remainingDurability = Math.max(1, (int)((float)maxDamage * durabilityPercent));
            itemStack.m_41721_(maxDamage - remainingDurability);
            if (itemStack.m_41773_() >= maxDamage) {
                itemStack.m_41721_(maxDamage - 1);
            }
            if (itemStack.m_41773_() < 0) {
                itemStack.m_41721_(0);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12310_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
    }

    public static boolean checkBanditSpawnRules(EntityType<BanditEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        if (!levelAccessor.m_6018_().m_46462_()) {
            return false;
        }
        return Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
    }
}

