/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.windows;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.bojarsky.bojarskyauthclient.libs.jna.platform.win32.COM.WbemcliUtil;
import net.bojarsky.bojarskyauthclient.libs.jna.platform.win32.Kernel32;
import net.bojarsky.bojarskyauthclient.libs.jna.platform.win32.Psapi;
import net.bojarsky.bojarskyauthclient.libs.jna.platform.win32.VersionHelpers;
import net.bojarsky.bojarskyauthclient.libs.oshi.annotation.concurrent.ThreadSafe;
import net.bojarsky.bojarskyauthclient.libs.oshi.driver.windows.wmi.Win32PhysicalMemory;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.PhysicalMemory;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.VirtualMemory;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.common.AbstractGlobalMemory;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.windows.WindowsVirtualMemory;
import net.bojarsky.bojarskyauthclient.libs.oshi.jna.Struct;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.Memoizer;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.platform.windows.WmiUtil;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.tuples.Triplet;
import net.bojarsky.bojarskyauthclient.libs.slf4j.Logger;
import net.bojarsky.bojarskyauthclient.libs.slf4j.LoggerFactory;

@ThreadSafe
final class WindowsGlobalMemory
extends AbstractGlobalMemory {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsGlobalMemory.class);
    private static final boolean IS_WINDOWS10_OR_GREATER = VersionHelpers.IsWindows10OrGreater();
    private final Supplier<Triplet<Long, Long, Long>> availTotalSize = Memoizer.memoize(WindowsGlobalMemory::readPerfInfo, Memoizer.defaultExpiration());
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    WindowsGlobalMemory() {
    }

    @Override
    public long getAvailable() {
        return this.availTotalSize.get().getA();
    }

    @Override
    public long getTotal() {
        return this.availTotalSize.get().getB();
    }

    @Override
    public long getPageSize() {
        return this.availTotalSize.get().getC();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private VirtualMemory createVirtualMemory() {
        return new WindowsVirtualMemory(this);
    }

    @Override
    public List<PhysicalMemory> getPhysicalMemory() {
        ArrayList<PhysicalMemory> physicalMemoryList = new ArrayList<PhysicalMemory>();
        if (IS_WINDOWS10_OR_GREATER) {
            WbemcliUtil.WmiResult<Win32PhysicalMemory.PhysicalMemoryProperty> bankMap = Win32PhysicalMemory.queryphysicalMemory();
            for (int index = 0; index < bankMap.getResultCount(); ++index) {
                String bankLabel = WmiUtil.getString(bankMap, Win32PhysicalMemory.PhysicalMemoryProperty.BANKLABEL, index);
                long capacity = WmiUtil.getUint64(bankMap, Win32PhysicalMemory.PhysicalMemoryProperty.CAPACITY, index);
                long speed = (long)WmiUtil.getUint32(bankMap, Win32PhysicalMemory.PhysicalMemoryProperty.SPEED, index) * 1000000L;
                String manufacturer = WmiUtil.getString(bankMap, Win32PhysicalMemory.PhysicalMemoryProperty.MANUFACTURER, index);
                String memoryType = WindowsGlobalMemory.smBiosMemoryType(WmiUtil.getUint32(bankMap, Win32PhysicalMemory.PhysicalMemoryProperty.SMBIOSMEMORYTYPE, index));
                String partNumber = WmiUtil.getString(bankMap, Win32PhysicalMemory.PhysicalMemoryProperty.PARTNUMBER, index);
                String serialNumber = WmiUtil.getString(bankMap, Win32PhysicalMemory.PhysicalMemoryProperty.SERIALNUMBER, index);
                physicalMemoryList.add(new PhysicalMemory(bankLabel, capacity, speed, manufacturer, memoryType, partNumber, serialNumber));
            }
        } else {
            WbemcliUtil.WmiResult<Win32PhysicalMemory.PhysicalMemoryPropertyWin8> bankMap = Win32PhysicalMemory.queryphysicalMemoryWin8();
            for (int index = 0; index < bankMap.getResultCount(); ++index) {
                String bankLabel = WmiUtil.getString(bankMap, Win32PhysicalMemory.PhysicalMemoryPropertyWin8.BANKLABEL, index);
                long capacity = WmiUtil.getUint64(bankMap, Win32PhysicalMemory.PhysicalMemoryPropertyWin8.CAPACITY, index);
                long speed = (long)WmiUtil.getUint32(bankMap, Win32PhysicalMemory.PhysicalMemoryPropertyWin8.SPEED, index) * 1000000L;
                String manufacturer = WmiUtil.getString(bankMap, Win32PhysicalMemory.PhysicalMemoryPropertyWin8.MANUFACTURER, index);
                String memoryType = WindowsGlobalMemory.memoryType(WmiUtil.getUint16(bankMap, Win32PhysicalMemory.PhysicalMemoryPropertyWin8.MEMORYTYPE, index));
                String partNumber = WmiUtil.getString(bankMap, Win32PhysicalMemory.PhysicalMemoryPropertyWin8.PARTNUMBER, index);
                String serialNumber = WmiUtil.getString(bankMap, Win32PhysicalMemory.PhysicalMemoryPropertyWin8.SERIALNUMBER, index);
                physicalMemoryList.add(new PhysicalMemory(bankLabel, capacity, speed, manufacturer, memoryType, partNumber, serialNumber));
            }
        }
        return physicalMemoryList;
    }

    private static String memoryType(int type) {
        switch (type) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Other";
            }
            case 2: {
                return "DRAM";
            }
            case 3: {
                return "Synchronous DRAM";
            }
            case 4: {
                return "Cache DRAM";
            }
            case 5: {
                return "EDO";
            }
            case 6: {
                return "EDRAM";
            }
            case 7: {
                return "VRAM";
            }
            case 8: {
                return "SRAM";
            }
            case 9: {
                return "RAM";
            }
            case 10: {
                return "ROM";
            }
            case 11: {
                return "Flash";
            }
            case 12: {
                return "EEPROM";
            }
            case 13: {
                return "FEPROM";
            }
            case 14: {
                return "EPROM";
            }
            case 15: {
                return "CDRAM";
            }
            case 16: {
                return "3DRAM";
            }
            case 17: {
                return "SDRAM";
            }
            case 18: {
                return "SGRAM";
            }
            case 19: {
                return "RDRAM";
            }
            case 20: {
                return "DDR";
            }
            case 21: {
                return "DDR2";
            }
            case 22: {
                return "BRAM";
            }
            case 23: {
                return "DDR FB-DIMM";
            }
        }
        return WindowsGlobalMemory.smBiosMemoryType(type);
    }

    private static String smBiosMemoryType(int type) {
        switch (type) {
            case 1: {
                return "Other";
            }
            case 3: {
                return "DRAM";
            }
            case 4: {
                return "EDRAM";
            }
            case 5: {
                return "VRAM";
            }
            case 6: {
                return "SRAM";
            }
            case 7: {
                return "RAM";
            }
            case 8: {
                return "ROM";
            }
            case 9: {
                return "FLASH";
            }
            case 10: {
                return "EEPROM";
            }
            case 11: {
                return "FEPROM";
            }
            case 12: {
                return "EPROM";
            }
            case 13: {
                return "CDRAM";
            }
            case 14: {
                return "3DRAM";
            }
            case 15: {
                return "SDRAM";
            }
            case 16: {
                return "SGRAM";
            }
            case 17: {
                return "RDRAM";
            }
            case 18: {
                return "DDR";
            }
            case 19: {
                return "DDR2";
            }
            case 20: {
                return "DDR2 FB-DIMM";
            }
            case 24: {
                return "DDR3";
            }
            case 25: {
                return "FBD2";
            }
            case 26: {
                return "DDR4";
            }
            case 27: {
                return "LPDDR";
            }
            case 28: {
                return "LPDDR2";
            }
            case 29: {
                return "LPDDR3";
            }
            case 30: {
                return "LPDDR4";
            }
            case 31: {
                return "Logical non-volatile device";
            }
            case 32: {
                return "HBM";
            }
            case 33: {
                return "HBM2";
            }
            case 34: {
                return "DDR5";
            }
            case 35: {
                return "LPDDR5";
            }
            case 36: {
                return "HBM3";
            }
        }
        return "Unknown";
    }

    private static Triplet<Long, Long, Long> readPerfInfo() {
        try (Struct.CloseablePerformanceInformation performanceInfo = new Struct.CloseablePerformanceInformation();){
            if (!Psapi.INSTANCE.GetPerformanceInfo(performanceInfo, performanceInfo.size())) {
                LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                Triplet<Long, Long, Long> triplet = new Triplet<Long, Long, Long>(0L, 0L, 4098L);
                return triplet;
            }
            long pageSize = performanceInfo.PageSize.longValue();
            long memAvailable = pageSize * performanceInfo.PhysicalAvailable.longValue();
            long memTotal = pageSize * performanceInfo.PhysicalTotal.longValue();
            Triplet<Long, Long, Long> triplet = new Triplet<Long, Long, Long>(memAvailable, memTotal, pageSize);
            return triplet;
        }
    }
}

