/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient.client.compat;

import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.bojarsky.bojarskyauthapi.network.ClientMetricsPacket;
import net.bojarsky.bojarskyauthapi.network.PacketHandler;
import net.bojarsky.bojarskyauthclient.client.compat.SystemMetricsCollector;
import org.slf4j.Logger;

public class SystemPerformanceMonitor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicBoolean isPeriodicCheckRunning = new AtomicBoolean(false);
    private static ScheduledExecutorService scheduler;

    public static void performInitialSnapshot() {
        LOGGER.info("Performing initial system snapshot for compatibility checks...");
        SystemMetricsCollector.collectInitialMetrics();
    }

    public static void startPeriodicChecks() {
        if (!isPeriodicCheckRunning.compareAndSet(false, true)) {
            LOGGER.warn("Periodic checks are already running. Ignoring redundant start call.");
            return;
        }
        LOGGER.info("Player connected. Starting periodic system checks...");
        scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "System-Compat-Monitor");
            t.setDaemon(true);
            return t;
        });
        Map<String, String> initialReport = SystemMetricsCollector.getInitialReportData();
        if (!initialReport.isEmpty()) {
            SystemPerformanceMonitor.sendMetricsToServer(initialReport);
        }
        scheduler.scheduleAtFixedRate(() -> {
            try {
                Map<String, String> runtimeAnomalies = SystemMetricsCollector.collectRuntimeAnomalies();
                if (!runtimeAnomalies.isEmpty()) {
                    SystemPerformanceMonitor.sendMetricsToServer(runtimeAnomalies);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during periodic system scan", (Throwable)e);
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }

    public static void stopPeriodicChecks() {
        if (!isPeriodicCheckRunning.compareAndSet(true, false)) {
            return;
        }
        LOGGER.info("Player disconnected. Stopping periodic system checks...");
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdownNow();
        }
    }

    private static void sendMetricsToServer(Map<String, String> metricsData) {
        LOGGER.info("Sending system compatibility metrics to server. Anomaly count: " + metricsData.size());
        if (!metricsData.isEmpty()) {
            metricsData.forEach((key, value) -> LOGGER.warn("SECURITY ANOMALY: {} -> {}", key, value));
        }
        ClientMetricsPacket packet = new ClientMetricsPacket(metricsData);
        PacketHandler.sendToServer((Object)packet);
    }
}

