/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage.model;

import com.eerussianguy.betterfoliage.BFConfig;
import com.eerussianguy.betterfoliage.Helpers;
import com.eerussianguy.betterfoliage.model.BFBakedModel;
import com.eerussianguy.betterfoliage.model.GrassConnectionData;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class GrassBakedModel
extends BFBakedModel {
    public static List<GrassBakedModel> INSTANCES = new ArrayList<GrassBakedModel>();
    public static final ChunkRenderTypeSet RENDER_TYPES = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    private final BlockModel blockModel;
    private final ResourceLocation modelLocation;
    private final ResourceLocation dirt;
    private final ResourceLocation top;
    private final ResourceLocation overlay;
    private final ResourceLocation grass;
    private final boolean tint;
    @Nullable
    private TextureAtlasSprite dirtTex;
    @Nullable
    private TextureAtlasSprite topTex;
    @Nullable
    private TextureAtlasSprite overlayTex;
    private final BakedModel[] models = new BakedModel[16];

    public GrassBakedModel(ResourceLocation modelLocation, ResourceLocation dirt, ResourceLocation top, ResourceLocation overlay, boolean tint, ResourceLocation grass) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        this.modelLocation = modelLocation;
        this.dirt = dirt;
        this.top = top;
        this.overlay = overlay;
        this.tint = tint;
        this.grass = grass;
        INSTANCES.add(this);
    }

    public void init() {
        this.dirtTex = Helpers.getTexture(this.dirt);
        this.topTex = Helpers.getTexture(this.top);
        this.overlayTex = Helpers.getTexture(this.overlay);
        this.generateModels();
    }

    private BlockElement buildCore() {
        EnumMap mapFaces = Maps.newEnumMap(Direction.class);
        for (Direction d : Helpers.DIRECTIONS) {
            BlockFaceUV faceUV = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
            mapFaces.put(d, d == Direction.UP && this.tint ? Helpers.makeTintedFace(faceUV) : Helpers.makeFace(faceUV));
        }
        return new BlockElement(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), (Map)mapFaces, null, true);
    }

    public void generateModels() {
        BlockElement core = this.buildCore();
        for (int meta = 0; meta < 16; ++meta) {
            EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
            for (Direction d : Helpers.DIRECTIONS) {
                BlockFaceUV faceUV = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
                mapFacesIn.put(d, d != Direction.DOWN && this.tint ? Helpers.makeTintedFace(faceUV) : Helpers.makeFace(faceUV));
            }
            BlockElement part = new BlockElement(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), (Map)mapFacesIn, null, true);
            assert (this.topTex != null);
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.f_111734_, false).m_119528_(this.topTex);
            int fMeta = meta;
            Helpers.assembleFacesConditional(builder, core, direction -> direction == Direction.UP ? this.topTex : this.dirtTex, this.modelLocation);
            Helpers.assembleFacesConditional(builder, part, direction -> this.resolveTexture((Direction)direction, GrassBakedModel.stateFromMeta(fMeta)), this.modelLocation);
            this.models[meta] = builder.build(NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation("cutout_mipped")));
        }
    }

    private TextureAtlasSprite resolveTexture(Direction d, boolean[] booleans) {
        assert (this.dirtTex != null && this.topTex != null && this.overlayTex != null);
        return switch (d) {
            case Direction.UP -> this.topTex;
            default -> this.dirtTex;
            case Direction.NORTH -> {
                if (booleans[0]) {
                    yield this.topTex;
                }
                yield this.overlayTex;
            }
            case Direction.EAST -> {
                if (booleans[1]) {
                    yield this.topTex;
                }
                yield this.overlayTex;
            }
            case Direction.SOUTH -> {
                if (booleans[2]) {
                    yield this.topTex;
                }
                yield this.overlayTex;
            }
            case Direction.WEST -> booleans[3] ? this.topTex : this.overlayTex;
        };
    }

    private static boolean[] stateFromMeta(int meta) {
        boolean[] state = new boolean[]{false, false, false, false};
        state[0] = (meta & 1) > 0;
        state[1] = (meta & 2) > 0;
        state[2] = (meta & 4) > 0;
        state[3] = (meta & 8) > 0;
        return state;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        GrassConnectionData grassData;
        if (extraData.has(GrassConnectionData.PROPERTY) && (grassData = (GrassConnectionData)extraData.get(GrassConnectionData.PROPERTY)) != null) {
            int meta = grassData.get();
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.models[meta].getQuads(state, side, rand, extraData, renderType));
            if (grassData.hasUp() && !this.grass.equals((Object)Helpers.EMPTY) && rand.m_188503_(((Integer)BFConfig.CLIENT.extraGrassRarity.get()).intValue()) == 0) {
                BakedModel grassModel = Minecraft.m_91087_().m_91304_().getModel(this.grass);
                quads.addAll(grassModel.getQuads(state, side, rand, extraData, renderType));
            }
            return quads;
        }
        return this.models[0].getQuads(state, side, rand, extraData, renderType);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData extraData) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos down = pos.m_7495_();
        boolean north = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)down, Direction.NORTH)).m_61138_((Property)BlockStateProperties.f_61451_);
        boolean east = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)down, Direction.EAST)).m_61138_((Property)BlockStateProperties.f_61451_);
        boolean south = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)down, Direction.SOUTH)).m_61138_((Property)BlockStateProperties.f_61451_);
        boolean west = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)down, Direction.WEST)).m_61138_((Property)BlockStateProperties.f_61451_);
        BlockState upState = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, Direction.UP));
        boolean up = upState.m_60795_() || upState.m_60713_(Blocks.f_50125_);
        return extraData.derive().with(GrassConnectionData.PROPERTY, (Object)new GrassConnectionData(north, east, south, west, up)).build();
    }

    public TextureAtlasSprite m_6160_() {
        return Objects.requireNonNull(this.dirtTex);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return RENDER_TYPES;
    }
}

