/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import de.mennomax.astikorcarts.util.Quat4f;
import net.minecraft.util.Mth;

public final class Mat4f {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;

    public Mat4f() {
    }

    public Mat4f(Mat4f matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m01;
        this.m02 = matrix.m02;
        this.m03 = matrix.m03;
        this.m10 = matrix.m10;
        this.m11 = matrix.m11;
        this.m12 = matrix.m12;
        this.m13 = matrix.m13;
        this.m20 = matrix.m20;
        this.m21 = matrix.m21;
        this.m22 = matrix.m22;
        this.m23 = matrix.m23;
        this.m30 = matrix.m30;
        this.m31 = matrix.m31;
        this.m32 = matrix.m32;
        this.m33 = matrix.m33;
    }

    public Mat4f makeIdentity() {
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m23 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        return this;
    }

    public Mat4f makeTranslation(float x, float y, float z) {
        this.makeIdentity();
        this.m03 = x;
        this.m13 = y;
        this.m23 = z;
        return this;
    }

    public Mat4f makeScale(float x, float y, float z) {
        this.makeIdentity();
        this.m00 = x;
        this.m11 = y;
        this.m22 = z;
        this.m33 = 1.0f;
        return this;
    }

    public Mat4f makeRotation(float angle, float x, float y, float z) {
        this.makeIdentity();
        float c = Mth.m_14089_((float)angle);
        float s = Mth.m_14031_((float)angle);
        float t = 1.0f - c;
        this.m00 = c + x * x * t;
        this.m11 = c + y * y * t;
        this.m22 = c + z * z * t;
        float a = x * y * t;
        float b = z * s;
        this.m10 = a + b;
        this.m01 = a - b;
        a = x * z * t;
        b = y * s;
        this.m20 = a - b;
        this.m02 = a + b;
        a = y * z * t;
        b = x * s;
        this.m21 = a + b;
        this.m12 = a - b;
        return this;
    }

    public void makeQuaternion(Quat4f quat) {
        this.makeQuaternion(quat.x, quat.y, quat.z, quat.w);
    }

    public void makeQuaternion(float x, float y, float z, float w) {
        this.makeIdentity();
        this.m00 = 1.0f - 2.0f * y * y - 2.0f * z * z;
        this.m10 = 2.0f * (x * y + w * z);
        this.m20 = 2.0f * (x * z - w * y);
        this.m01 = 2.0f * (x * y - w * z);
        this.m11 = 1.0f - 2.0f * x * x - 2.0f * z * z;
        this.m21 = 2.0f * (y * z + w * x);
        this.m02 = 2.0f * (x * z + w * y);
        this.m12 = 2.0f * (y * z - w * x);
        this.m22 = 1.0f - 2.0f * x * x - 2.0f * y * y;
    }

    public void makePerspective(float fovy, float aspect, float zNear, float zFar) {
        this.makeIdentity();
        float radians = (float)Math.toRadians(fovy / 2.0f);
        float deltaZ = zFar - zNear;
        float sine = Mth.m_14031_((float)radians);
        if (deltaZ == 0.0f || sine == 0.0f || aspect == 0.0f) {
            return;
        }
        float cotangent = Mth.m_14089_((float)radians) / sine;
        this.m00 = cotangent / aspect;
        this.m11 = cotangent;
        this.m22 = -(zFar + zNear) / deltaZ;
        this.m32 = -1.0f;
        this.m23 = -2.0f * zNear * zFar / deltaZ;
    }

    public void makeOrtho(float left, float right, float bottom, float top, float zNear, float zFar) {
        this.makeIdentity();
        this.m00 = 2.0f / (right - left);
        this.m11 = 2.0f / (top - bottom);
        this.m22 = -2.0f / (zFar - zNear);
        this.m03 = -(right + left) / (right - left);
        this.m13 = -(top + bottom) / (top - bottom);
        this.m23 = -(zFar - zNear) / (zFar - zNear);
    }

    public void mul(Mat4f m) {
        float m00 = this.m00 * m.m00 + this.m01 * m.m10 + this.m02 * m.m20 + this.m03 * m.m30;
        float m01 = this.m00 * m.m01 + this.m01 * m.m11 + this.m02 * m.m21 + this.m03 * m.m31;
        float m02 = this.m00 * m.m02 + this.m01 * m.m12 + this.m02 * m.m22 + this.m03 * m.m32;
        float m03 = this.m00 * m.m03 + this.m01 * m.m13 + this.m02 * m.m23 + this.m03 * m.m33;
        float m10 = this.m10 * m.m00 + this.m11 * m.m10 + this.m12 * m.m20 + this.m13 * m.m30;
        float m11 = this.m10 * m.m01 + this.m11 * m.m11 + this.m12 * m.m21 + this.m13 * m.m31;
        float m12 = this.m10 * m.m02 + this.m11 * m.m12 + this.m12 * m.m22 + this.m13 * m.m32;
        float m13 = this.m10 * m.m03 + this.m11 * m.m13 + this.m12 * m.m23 + this.m13 * m.m33;
        float m20 = this.m20 * m.m00 + this.m21 * m.m10 + this.m22 * m.m20 + this.m23 * m.m30;
        float m21 = this.m20 * m.m01 + this.m21 * m.m11 + this.m22 * m.m21 + this.m23 * m.m31;
        float m22 = this.m20 * m.m02 + this.m21 * m.m12 + this.m22 * m.m22 + this.m23 * m.m32;
        float m23 = this.m20 * m.m03 + this.m21 * m.m13 + this.m22 * m.m23 + this.m23 * m.m33;
        float m30 = this.m30 * m.m00 + this.m31 * m.m10 + this.m32 * m.m20 + this.m33 * m.m30;
        float m31 = this.m30 * m.m01 + this.m31 * m.m11 + this.m32 * m.m21 + this.m33 * m.m31;
        float m32 = this.m30 * m.m02 + this.m31 * m.m12 + this.m32 * m.m22 + this.m33 * m.m32;
        float m33 = this.m30 * m.m03 + this.m31 * m.m13 + this.m32 * m.m23 + this.m33 * m.m33;
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public boolean invert() {
        float m00 = this.m00;
        float m01 = this.m01;
        float m02 = this.m02;
        float m03 = this.m03;
        float m10 = this.m10;
        float m11 = this.m11;
        float m12 = this.m12;
        float m13 = this.m13;
        float m20 = this.m20;
        float m21 = this.m21;
        float m22 = this.m22;
        float m23 = this.m23;
        float m30 = this.m30;
        float m31 = this.m31;
        float m32 = this.m32;
        float m33 = this.m33;
        this.m00 = m11 * m22 * m33 - m11 * m23 * m32 - m21 * m12 * m33 + m21 * m13 * m32 + m31 * m12 * m23 - m31 * m13 * m22;
        this.m10 = -m10 * m22 * m33 + m10 * m23 * m32 + m20 * m12 * m33 - m20 * m13 * m32 - m30 * m12 * m23 + m30 * m13 * m22;
        this.m20 = m10 * m21 * m33 - m10 * m23 * m31 - m20 * m11 * m33 + m20 * m13 * m31 + m30 * m11 * m23 - m30 * m13 * m21;
        this.m30 = -m10 * m21 * m32 + m10 * m22 * m31 + m20 * m11 * m32 - m20 * m12 * m31 - m30 * m11 * m22 + m30 * m12 * m21;
        this.m01 = -m01 * m22 * m33 + m01 * m23 * m32 + m21 * m02 * m33 - m21 * m03 * m32 - m31 * m02 * m23 + m31 * m03 * m22;
        this.m11 = m00 * m22 * m33 - m00 * m23 * m32 - m20 * m02 * m33 + m20 * m03 * m32 + m30 * m02 * m23 - m30 * m03 * m22;
        this.m21 = -m00 * m21 * m33 + m00 * m23 * m31 + m20 * m01 * m33 - m20 * m03 * m31 - m30 * m01 * m23 + m30 * m03 * m21;
        this.m31 = m00 * m21 * m32 - m00 * m22 * m31 - m20 * m01 * m32 + m20 * m02 * m31 + m30 * m01 * m22 - m30 * m02 * m21;
        this.m02 = m01 * m12 * m33 - m01 * m13 * m32 - m11 * m02 * m33 + m11 * m03 * m32 + m31 * m02 * m13 - m31 * m03 * m12;
        this.m12 = -m00 * m12 * m33 + m00 * m13 * m32 + m10 * m02 * m33 - m10 * m03 * m32 - m30 * m02 * m13 + m30 * m03 * m12;
        this.m22 = m00 * m11 * m33 - m00 * m13 * m31 - m10 * m01 * m33 + m10 * m03 * m31 + m30 * m01 * m13 - m30 * m03 * m11;
        this.m32 = -m00 * m11 * m32 + m00 * m12 * m31 + m10 * m01 * m32 - m10 * m02 * m31 - m30 * m01 * m12 + m30 * m02 * m11;
        this.m03 = -m01 * m12 * m23 + m01 * m13 * m22 + m11 * m02 * m23 - m11 * m03 * m22 - m21 * m02 * m13 + m21 * m03 * m12;
        this.m13 = m00 * m12 * m23 - m00 * m13 * m22 - m10 * m02 * m23 + m10 * m03 * m22 + m20 * m02 * m13 - m20 * m03 * m12;
        this.m23 = -m00 * m11 * m23 + m00 * m13 * m21 + m10 * m01 * m23 - m10 * m03 * m21 - m20 * m01 * m13 + m20 * m03 * m11;
        this.m33 = m00 * m11 * m22 - m00 * m12 * m21 - m10 * m01 * m22 + m10 * m02 * m21 + m20 * m01 * m12 - m20 * m02 * m11;
        float var18 = m00 * this.m00 + m01 * this.m10 + m02 * this.m20 + m03 * this.m30;
        if (var18 == 0.0f) {
            return false;
        }
        var18 = 1.0f / var18;
        this.m00 *= var18;
        this.m01 *= var18;
        this.m02 *= var18;
        this.m03 *= var18;
        this.m10 *= var18;
        this.m11 *= var18;
        this.m12 *= var18;
        this.m13 *= var18;
        this.m20 *= var18;
        this.m21 *= var18;
        this.m22 *= var18;
        this.m23 *= var18;
        this.m30 *= var18;
        this.m31 *= var18;
        this.m32 *= var18;
        this.m33 *= var18;
        return true;
    }

    public float[] toArray() {
        return new float[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
    }
}

