/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.client.texture.TileTexture;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureConfig
implements ResourceReloadListener<Map<ResourceLocation, ITexture>> {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("textures");
    private final Map<ResourceLocation, ITexture> texture_map;

    public TextureConfig(Map<ResourceLocation, ITexture> texture_map) {
        this.texture_map = texture_map;
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, ITexture>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, TileTexture> textures = new HashMap<ResourceLocation, TileTexture>();
            for (ResourceLocation id2 : manager.m_214159_("textures/gui/tiles", id -> id.toString().endsWith(".png")).keySet()) {
                try {
                    ResourceLocation texture_id = new ResourceLocation(id2.m_135827_(), id2.m_135815_().replace("textures/gui/tiles/", "").replace(".png", ""));
                    textures.put(texture_id, new TileTexture(id2));
                }
                catch (ResourceLocationException e) {
                    AntiqueAtlasMod.LOG.warn("Failed to read texture!", (Throwable)e);
                }
            }
            return textures;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, ITexture> textures, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            this.texture_map.clear();
            for (Map.Entry entry : textures.entrySet()) {
                this.texture_map.put((ResourceLocation)entry.getKey(), (ITexture)entry.getValue());
                if (!AntiqueAtlasMod.CONFIG.resourcePackLogging) continue;
                Log.info("Loaded texture %s with path %s", entry.getKey(), ((ITexture)entry.getValue()).getTexture());
            }
        }, executor);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }
}

