/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.data.recipes;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ShapelessRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final String folderName;
    private final CraftingBookCategory craftingBookCategory;
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;

    public ShapelessRecipeBuilder(CraftingBookCategory craftingBookCategory, String folderName, ItemLike result, int count) {
        this.craftingBookCategory = craftingBookCategory;
        this.folderName = folderName;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ShapelessRecipeBuilder shapeless(ItemLike result) {
        return ShapelessRecipeBuilder.shapeless("crafting", result);
    }

    public static ShapelessRecipeBuilder shapeless(ItemLike result, int count) {
        return ShapelessRecipeBuilder.shapeless("crafting", result, count);
    }

    public static ShapelessRecipeBuilder shapeless(String folderName, ItemLike result) {
        return ShapelessRecipeBuilder.shapeless(folderName, result, 1);
    }

    public static ShapelessRecipeBuilder shapeless(String folderName, ItemLike result, int count) {
        return new ShapelessRecipeBuilder(CraftingBookCategory.MISC, folderName, result, count);
    }

    public ShapelessRecipeBuilder requires(TagKey<Item> pTag) {
        return this.requires(Ingredient.m_204132_(pTag));
    }

    public ShapelessRecipeBuilder requires(ItemLike pItem) {
        return this.requires(pItem, 1);
    }

    public ShapelessRecipeBuilder requires(ItemLike pItem, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItem}));
        }
        return this;
    }

    public ShapelessRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public ShapelessRecipeBuilder requires(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public ShapelessRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_176498_(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        this.m_126140_(finishedRecipeConsumer, RecipeBuilder.m_176493_((ItemLike)this.m_142372_()).m_246208_(this.folderName + "/"));
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        finishedRecipeConsumer.accept((FinishedRecipe)new ShapelessRecipeBuilder.Result(recipeId, this.result, this.count, this.group == null ? "" : this.group, this.craftingBookCategory, this.ingredients, this.advancement, recipeId.m_246208_("recipes/" + this.folderName + "/")));
    }

    private void ensureValid(ResourceLocation recipeId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }
}

