/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.data.loot;

import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.block.AngledWoodenBoatFrameBlock;
import com.alekiponi.alekiships.common.block.FlatWoodenBoatFrameBlock;
import com.alekiponi.alekiships.common.block.ProcessedBoatFrame;
import com.alekiponi.alekiships.data.DataGenHelper;
import com.alekiponi.alekiships.util.BoatMaterial;
import java.util.Set;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraftforge.registries.RegistryObject;

public class AlekiShipsBlockLootTables
extends BlockLootSubProvider {
    protected AlekiShipsBlockLootTables(Set<Item> explosionResistant) {
        super(explosionResistant, FeatureFlags.f_244280_.m_247355_());
    }

    public AlekiShipsBlockLootTables() {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
    }

    public static <B extends Block> LootPool.Builder createProcessedFrameTable(B block, Item plankItem, int plankStates) {
        LootPool.Builder contentsPool = LootPool.m_79043_();
        for (int propertyValue = 0; propertyValue < plankStates; ++propertyValue) {
            LootPoolSingletonContainer.Builder lootItem = DataGenHelper.setCount(LootItem.m_79579_((ItemLike)plankItem), propertyValue, true);
            contentsPool.m_79076_((LootPoolEntryContainer.Builder)DataGenHelper.matchProperty(lootItem, block, (Property<Integer>)((ProcessedBoatFrame)block).getProcessingProperty(), propertyValue));
        }
        return contentsPool;
    }

    protected void m_245660_() {
        this.m_245724_((Block)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get());
        AlekiShipsBlocks.WOODEN_BOAT_FRAME_ANGLED.forEach(this::dropAngledWoodenFrame);
        AlekiShipsBlocks.WOODEN_BOAT_FRAME_FLAT.forEach(this::dropFlatWoodenFrame);
        this.m_245724_((Block)AlekiShipsBlocks.BOAT_FRAME_FLAT.get());
        this.m_245724_((Block)AlekiShipsBlocks.OARLOCK.get());
        this.m_245724_((Block)AlekiShipsBlocks.CLEAT.get());
    }

    private void dropAngledWoodenFrame(BoatMaterial material, RegistryObject<AngledWoodenBoatFrameBlock> registryObject) {
        this.m_247577_((Block)registryObject.get(), this.m_247033_((ItemLike)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get()).m_79161_((LootPool.Builder)this.m_247733_((ItemLike)material.getDeckItem(), (ConditionUserBuilder)AlekiShipsBlockLootTables.createProcessedFrameTable((AngledWoodenBoatFrameBlock)registryObject.get(), material.getDeckItem(), 4))));
    }

    private void dropFlatWoodenFrame(BoatMaterial material, RegistryObject<FlatWoodenBoatFrameBlock> registryObject) {
        this.m_247577_((Block)registryObject.get(), this.m_247033_((ItemLike)AlekiShipsBlocks.BOAT_FRAME_FLAT.get()).m_79161_((LootPool.Builder)this.m_247733_((ItemLike)material.getDeckItem(), (ConditionUserBuilder)AlekiShipsBlockLootTables.createProcessedFrameTable((FlatWoodenBoatFrameBlock)registryObject.get(), material.getDeckItem(), 4))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return AlekiShipsBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
    }
}

