/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.block;

import com.alekiponi.alekiships.common.block.AbstractHullSideBlock;
import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.BoatFrame;
import com.alekiponi.alekiships.common.block.ProcessedBoatFrame;
import com.alekiponi.alekiships.common.block.ShipbuildingMultiblocks;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.util.BoatMaterial;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CleatBlock
extends AbstractHullSideBlock {
    private static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)2.0, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)5.0, (double)0.0, (double)12.0, (double)11.0, (double)2.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_WEST = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)4.0, (double)2.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_EAST = Stream.of(Block.m_49796_((double)12.0, (double)0.0, (double)5.0, (double)14.0, (double)2.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    protected CleatBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape m_5940_(BlockState pstate, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pstate.m_61143_((Property)FACING);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP, Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            this.validateMultiblock(pLevel, pPos, pState);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void validateMultiblock(Level level, BlockPos thispos, BlockState blockState) {
        Block block;
        BlockState frameState;
        BoatMaterial boatMaterial;
        Direction structureDirection;
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        Direction.Axis axis = direction.m_122427_().m_122434_();
        BlockPos crosspos = thispos.m_5484_(direction.m_122424_(), 3);
        BlockPos[] cleats = new BlockPos[4];
        cleats[0] = thispos;
        if (level.m_8055_(crosspos).m_60713_((Block)AlekiShipsBlocks.CLEAT.get()) && level.m_8055_(crosspos).m_61143_((Property)FACING) == direction.m_122424_()) {
            cleats[1] = crosspos;
            BlockPos[] forwardPos = thispos.m_5487_(axis, 4);
            BlockPos backwardPos = thispos.m_5487_(axis, -4);
            if (level.m_8055_((BlockPos)forwardPos).m_60713_((Block)AlekiShipsBlocks.CLEAT.get()) && level.m_8055_((BlockPos)forwardPos).m_61143_((Property)FACING) == direction) {
                crosspos = forwardPos.m_5484_(direction.m_122424_(), 3);
                if (level.m_8055_(crosspos).m_60713_((Block)AlekiShipsBlocks.CLEAT.get()) && level.m_8055_(crosspos).m_61143_((Property)FACING) == direction.m_122424_()) {
                    cleats[2] = thispos;
                    cleats[3] = cleats[1];
                    cleats[0] = forwardPos;
                    cleats[1] = crosspos;
                }
            } else if (level.m_8055_(backwardPos).m_60713_((Block)AlekiShipsBlocks.CLEAT.get()) && level.m_8055_(backwardPos).m_61143_((Property)FACING) == direction && level.m_8055_(crosspos = backwardPos.m_5484_(direction.m_122424_(), 3)).m_60713_((Block)AlekiShipsBlocks.CLEAT.get()) && level.m_8055_(crosspos).m_61143_((Property)FACING) == direction.m_122424_()) {
                cleats[2] = backwardPos;
                cleats[3] = crosspos;
            }
        }
        for (BlockPos blockPos : cleats) {
            if (blockPos != null) continue;
            return;
        }
        Direction.Axis crossAxis = Direction.Axis.X;
        if (axis == Direction.Axis.X) {
            crossAxis = Direction.Axis.Z;
        }
        if (cleats[0].m_123304_(crossAxis) > cleats[1].m_123304_(crossAxis)) {
            BlockPos[] newCleats = new BlockPos[]{cleats[1], cleats[0], cleats[3], cleats[2]};
            cleats = newCleats;
        }
        if (level.m_8055_(cleats[0].m_7495_().m_5487_(crossAxis, 1).m_5487_(axis, 2)).m_60734_() instanceof AngledBoatFrameBlock) {
            structureDirection = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        } else {
            structureDirection = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
            BlockPos[] newCleats = new BlockPos[]{cleats[2], cleats[3], cleats[0], cleats[1]};
            cleats = newCleats;
        }
        BlockPos origin = cleats[0].m_5484_(structureDirection, 2).m_7495_();
        if (structureDirection == Direction.WEST || structureDirection == Direction.SOUTH) {
            origin = cleats[1].m_5484_(structureDirection, 2).m_7495_();
        }
        if ((boatMaterial = BoatFrame.fromBlockstate(frameState = level.m_8055_(thispos.m_7495_()))) == null) {
            return;
        }
        if (ShipbuildingMultiblocks.validateShipHull(level, origin, structureDirection, ShipbuildingMultiblocks.Multiblock.SLOOP, boatMaterial) && frameState.m_60734_() instanceof AngledBoatFrameBlock && (block = frameState.m_60734_()) instanceof ProcessedBoatFrame) {
            ProcessedBoatFrame boatFrameBlock = (ProcessedBoatFrame)block;
            BlockPos pos1 = origin.m_5484_(structureDirection.m_122424_(), 3).m_5484_(structureDirection.m_122427_(), 1);
            BlockPos pos2 = origin.m_5484_(structureDirection.m_122424_(), 5).m_5484_(structureDirection.m_122427_(), 3);
            Vec3 spawnPosition = new Vec3((double)(pos1.m_123341_() + pos2.m_123341_()), (double)(pos1.m_123342_() + pos2.m_123342_()), (double)(pos1.m_123343_() + pos2.m_123343_())).m_82542_(0.5, 0.5, 0.5);
            if (structureDirection == Direction.EAST || structureDirection == Direction.SOUTH) {
                spawnPosition = spawnPosition.m_82520_(1.0, 0.0, 0.0);
            }
            if (structureDirection == Direction.WEST || structureDirection == Direction.SOUTH) {
                spawnPosition = spawnPosition.m_82520_(0.0, 0.0, 1.0);
            }
            Vec3 finalSpawnPosition = spawnPosition;
            boatFrameBlock.getBoatMaterial().getEntityType(BoatMaterial.BoatType.CONSTRUCTION_SLOOP).ifPresent(entityType -> {
                AbstractVehicle sloop = (AbstractVehicle)entityType.m_20615_(level);
                if (sloop != null) {
                    sloop.m_146884_(finalSpawnPosition);
                    if (structureDirection == Direction.NORTH) {
                        sloop.m_146922_(180.0f);
                    } else if (structureDirection == Direction.EAST) {
                        sloop.m_146922_(-90.0f);
                    } else if (structureDirection == Direction.WEST) {
                        sloop.m_146922_(90.0f);
                    }
                    level.m_7967_((Entity)sloop);
                }
            });
        }
    }
}

