/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.block;

import com.alekiponi.alekiships.common.block.AlekiShipsBlockStateProperties;
import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.CleatBlock;
import com.alekiponi.alekiships.common.block.OarlockBlock;
import com.alekiponi.alekiships.common.block.ProcessedBoatFrame;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.CommonHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;

public class AngledWoodenBoatFrameBlock
extends AngledBoatFrameBlock
implements ProcessedBoatFrame {
    public static final IntegerProperty FRAME_PROCESSED = AlekiShipsBlockStateProperties.FRAME_PROCESSED;
    public static final int FULLY_PROCESSED = 3;
    public final BoatMaterial boatMaterial;

    public AngledWoodenBoatFrameBlock(BoatMaterial boatMaterial, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FRAME_PROCESSED, (Comparable)Integer.valueOf(0)));
        this.boatMaterial = boatMaterial;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{FRAME_PROCESSED}));
    }

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack heldStack = player.m_21120_(hand);
        int processState = (Integer)blockState.m_61143_((Property)FRAME_PROCESSED);
        if (heldStack.m_41619_() && !level.f_46443_) {
            if (processState <= 3) {
                CommonHelper.giveItemToPlayer(player, new ItemStack((ItemLike)this.boatMaterial.getDeckItem()));
            }
            if (processState == 0) {
                BlockState newState = (BlockState)((BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)SHAPE, (Comparable)((StairsShape)blockState.m_61143_((Property)SHAPE)))).m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING)));
                level.m_46597_(blockPos, newState);
                return InteractionResult.SUCCESS;
            }
            level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)FRAME_PROCESSED, (Comparable)Integer.valueOf(processState - 1)));
            return InteractionResult.SUCCESS;
        }
        if (heldStack.m_150930_(this.boatMaterial.getDeckItem())) {
            if (processState < 3) {
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
                level.m_46597_(blockPos, (BlockState)blockState.m_61122_((Property)FRAME_PROCESSED));
                level.m_5594_(null, blockPos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.5f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
                if (processState + 1 == 3) {
                    AngledWoodenBoatFrameBlock.triggerDetection(level, blockPos);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static void triggerDetection(Level level, BlockPos blockPos) {
        BlockPos search = blockPos.m_7494_();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos cur = search.m_5487_(Direction.Axis.X, x).m_5487_(Direction.Axis.Z, z);
                Block block = level.m_8055_(cur).m_60734_();
                if (block instanceof CleatBlock) {
                    CleatBlock cleat = (CleatBlock)block;
                    cleat.validateMultiblock(level, cur, level.m_8055_(cur));
                }
                if (!((block = level.m_8055_(cur).m_60734_()) instanceof OarlockBlock)) continue;
                OarlockBlock oarlock = (OarlockBlock)block;
                oarlock.validateMultiblock(level, cur, level.m_8055_(cur));
            }
        }
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return ((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_7397_(blockGetter, blockPos, blockState);
    }

    @Override
    public IntegerProperty getProcessingProperty() {
        return FRAME_PROCESSED;
    }

    @Override
    public int getProcessingLimit() {
        return 3;
    }

    @Override
    public BoatMaterial getBoatMaterial() {
        return this.boatMaterial;
    }
}

