/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.compat.jade;

import com.therighthon.afc.common.blockentities.TapBlockEntity;
import com.therighthon.afc.common.blocks.TapBlock;
import com.therighthon.afc.common.recipe.TreeTapRecipe;
import java.util.HashSet;
import java.util.LinkedList;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class TapBlockEntityProvider
implements IBlockComponentProvider {
    public static final ResourceLocation UID = new ResourceLocation("afc", "tap");
    public static final TapBlockEntityProvider INSTANCE = new TapBlockEntityProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Level level = accessor.getLevel();
        BlockState state = accessor.getBlockState();
        BlockPos pos = accessor.getPosition();
        BlockPos logPos = this.getLogPos(pos, (Direction)state.m_61143_((Property)TapBlock.FACING));
        BlockState logState = level.m_8055_(logPos);
        boolean isSpring = TapBlockEntity.isSpring(level);
        float currentTemp = Climate.getTemperature((Level)level, (BlockPos)pos);
        int totalTapCount = this.countTapsOnTree(level, logPos);
        float efficiency = 1.0f / (float)Math.max(1, totalTapCount);
        TreeTapRecipe recipe = TreeTapRecipe.getRecipe(logState);
        if (recipe == null) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.afc.tap.no_recipe").m_130940_(ChatFormatting.RED));
            return;
        }
        FluidStack outputFluid = recipe.getOutput();
        if (!outputFluid.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.afc.tap.fluid").m_130940_(ChatFormatting.GOLD).m_7220_((Component)outputFluid.getDisplayName().m_6881_().m_130940_(ChatFormatting.GRAY)));
            int amount = outputFluid.getAmount();
            tooltip.add((Component)Component.m_237115_((String)"tooltip.afc.tap.amount").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)(amount + " mB")).m_130940_(ChatFormatting.BLUE)));
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.afc.tap.temp_range").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.format("%.1f\u00b0C", Float.valueOf(recipe.getMinTemp()))).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)String.format("%.1f\u00b0C", Float.valueOf(recipe.getMaxTemp()))).m_130940_(ChatFormatting.RED)));
        if (recipe.springOnly().booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.afc.tap.spring").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)(isSpring ? "Yes" : "No")).m_130940_(isSpring ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
        tooltip.add((Component)Component.m_237110_((String)"tooltip.afc.tap.current_temp", (Object[])new Object[]{Component.m_237113_((String)String.format("%.1f\u00b0C", Float.valueOf(currentTemp))).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.afc.tap.efficiency").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.format("%.2f", Float.valueOf(efficiency))).m_130940_(efficiency >= 1.0f ? ChatFormatting.GREEN : ChatFormatting.RED)));
    }

    private int countTapsOnTree(Level level, BlockPos startPos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        BlockState logState = level.m_8055_(startPos);
        int tapCount = 0;
        queue.add(startPos);
        visited.add(startPos);
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            for (Direction dir : Direction.values()) {
                BlockPos tapPos = currentPos.m_121945_(dir);
                BlockState tapState = level.m_8055_(tapPos);
                if (!(tapState.m_60734_() instanceof TapBlock)) continue;
                ++tapCount;
            }
            for (Direction dir : Direction.values()) {
                BlockPos nextPos = currentPos.m_121945_(dir);
                if (visited.contains(nextPos) || !level.m_8055_(nextPos).m_60713_(logState.m_60734_())) continue;
                visited.add(nextPos);
                queue.add(nextPos);
            }
        }
        return tapCount;
    }

    private BlockPos getLogPos(BlockPos tapPos, Direction facing) {
        return tapPos.m_121945_(facing.m_122424_());
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

