/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.therighthon.afc.common.world.AFCPlacements;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ElevationRestrictedPlacement
extends PlacementModifier {
    public static final Codec<ElevationRestrictedPlacement> PLACEMENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min_elevation", (Object)Integer.MIN_VALUE).forGetter(c -> c.minElev), (App)Codec.INT.optionalFieldOf("max_elevation", (Object)Integer.MAX_VALUE).forGetter(c -> c.maxElev)).apply((Applicative)instance, ElevationRestrictedPlacement::new));
    private final int minElev;
    private final int maxElev;

    public ElevationRestrictedPlacement(int minElev, int maxElev) {
        this.minElev = minElev;
        this.maxElev = maxElev;
    }

    public int getMinElev() {
        return this.minElev;
    }

    public int getMaxElev() {
        return this.maxElev;
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)AFCPlacements.ELEVATION_RESTRICTED.get();
    }

    public boolean isValid(BlockPos pos) {
        int elev = pos.m_123342_();
        return elev >= this.minElev && elev <= this.maxElev;
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        return this.isValid(pos) ? Stream.of(pos) : Stream.empty();
    }
}

