/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.therighthon.afc.common.recipe.AFCRecipeTypes;
import com.therighthon.afc.common.recipe.TapInventory;
import javax.annotation.Nullable;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class TreeTapRecipe
implements ISimpleRecipe<TapInventory> {
    private final Boolean requiresNaturalLog;
    private final ResourceLocation id;
    private final FluidStack output;
    private final BlockIngredient blockIngredient;
    private final Boolean springOnly;
    private final float minTemp;
    private final float maxTemp;
    public static final IndirectHashCollection<Block, TreeTapRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().blocks(), AFCRecipeTypes.TREE_TAPPING_RECIPE);

    public TreeTapRecipe(ResourceLocation id, FluidStack output, BlockIngredient blockIngredient, Boolean requiresNaturalLog, Boolean springOnly, float minTemp, float maxTemp) {
        this.id = id;
        this.output = output;
        this.blockIngredient = blockIngredient;
        this.requiresNaturalLog = requiresNaturalLog;
        this.springOnly = springOnly;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
    }

    public static TreeTapRecipe getRecipe(BlockState state) {
        for (TreeTapRecipe recipe : CACHE.getAll((Object)state.m_60734_())) {
            if (!recipe.matches(state)) continue;
            return recipe;
        }
        return null;
    }

    public boolean matches(TapInventory inv, Level level) {
        return this.matches(inv.getState());
    }

    public boolean matches(BlockState state) {
        return this.blockIngredient.test(state);
    }

    public float getMinTemp() {
        return this.minTemp;
    }

    public float getMaxTemp() {
        return this.maxTemp;
    }

    public Boolean springOnly() {
        return this.springOnly;
    }

    public BlockIngredient getBlockIngredient() {
        return this.blockIngredient;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public Boolean requiresNaturalLog() {
        return this.requiresNaturalLog;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)AFCRecipeTypes.TREE_TAPPING_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<TreeTapRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("afc", "tree_tapping");

        public TreeTapRecipe fromJson(ResourceLocation id, JsonObject json) {
            FluidStack output = json.has("result_fluid") ? JsonHelpers.getFluidStack((JsonObject)json.getAsJsonObject("result_fluid")) : FluidStack.EMPTY;
            float minTemp = json.has("minimum_temperature") ? JsonHelpers.m_13915_((JsonObject)json, (String)"minimum_temperature") : -50.0f;
            float maxTemp = json.has("maximum_temperature") ? JsonHelpers.m_13915_((JsonObject)json, (String)"maximum_temperature") : 50.0f;
            Boolean requiresNaturalLog = json.has("requires_natural_log") ? JsonHelpers.m_13912_((JsonObject)json, (String)"requires_natural_log") : Boolean.TRUE;
            Boolean springOnly = json.has("spring_only") ? JsonHelpers.m_13912_((JsonObject)json, (String)"spring_only") : Boolean.FALSE;
            BlockIngredient blockIngredient = BlockIngredient.fromJson((JsonElement)JsonHelpers.get((JsonObject)json, (String)"input_block"));
            return new TreeTapRecipe(id, output, blockIngredient, requiresNaturalLog, springOnly, minTemp, maxTemp);
        }

        @Nullable
        public TreeTapRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            BlockIngredient recipeBlock = BlockIngredient.fromNetwork((FriendlyByteBuf)buffer);
            FluidStack output = buffer.readFluidStack();
            float minTemp = buffer.readFloat();
            float maxTemp = buffer.readFloat();
            Boolean springOnly = buffer.readBoolean();
            Boolean requiresNaturalLog = buffer.readBoolean();
            return new TreeTapRecipe(id, output, recipeBlock, requiresNaturalLog, springOnly, minTemp, maxTemp);
        }

        public void toNetwork(FriendlyByteBuf buffer, TreeTapRecipe recipe) {
            recipe.blockIngredient.toNetwork(buffer);
            buffer.writeFluidStack(recipe.output);
            buffer.writeFloat(recipe.minTemp);
            buffer.writeFloat(recipe.maxTemp);
            buffer.writeBoolean(recipe.springOnly.booleanValue());
            buffer.writeBoolean(recipe.requiresNaturalLog.booleanValue());
        }
    }
}

