/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.items;

import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.entities.AFCEntities;
import com.therighthon.afc.common.fluids.AFCFluids;
import com.therighthon.afc.common.fluids.SimpleAFCFluid;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.items.TFCBoatItem;
import net.dries007.tfc.common.items.TFCMinecartItem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AFCItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"afc");
    public static final Map<AFCWood, RegistryObject<Item>> LUMBER = Helpers.mapOfKeys(AFCWood.class, wood -> AFCItems.register("wood/lumber/" + wood.name()));
    public static final Map<AFCWood, RegistryObject<Item>> SUPPORTS = Helpers.mapOfKeys(AFCWood.class, wood -> AFCItems.register("wood/support/" + wood.name(), () -> new StandingAndWallBlockItem((Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.VERTICAL_SUPPORT).get(), (Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.HORIZONTAL_SUPPORT).get(), new Item.Properties(), Direction.DOWN)));
    public static final Map<AFCWood, RegistryObject<Item>> BOATS = Helpers.mapOfKeys(AFCWood.class, wood -> AFCItems.register("wood/boat/" + wood.name(), () -> new TFCBoatItem((Supplier)AFCEntities.BOATS.get(wood), new Item.Properties())));
    public static final Map<AFCWood, RegistryObject<Item>> CHEST_MINECARTS = Helpers.mapOfKeys(AFCWood.class, wood -> AFCItems.register("wood/chest_minecart/" + wood.name(), () -> new TFCMinecartItem(new Item.Properties(), (Supplier)TFCEntities.CHEST_MINECART, () -> ((Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.CHEST).get()).m_5456_())));
    public static final Map<AFCWood, RegistryObject<Item>> SIGNS = Helpers.mapOfKeys(AFCWood.class, wood -> AFCItems.register("wood/sign/" + wood.name(), () -> new SignItem(new Item.Properties(), (Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.SIGN).get(), (Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.WALL_SIGN).get())));
    public static final Map<AFCWood, Map<Metal.Default, RegistryObject<Item>>> HANGING_SIGNS = Helpers.mapOfKeys(AFCWood.class, wood -> Helpers.mapOfKeys(Metal.Default.class, Metal.Default::hasUtilities, metal -> AFCItems.register("wood/hanging_sign/" + metal.name() + "/" + wood.name(), () -> new HangingSignItem((Block)AFCBlocks.CEILING_HANGING_SIGNS.get(wood).get(metal).get(), (Block)AFCBlocks.WALL_HANGING_SIGNS.get(wood).get(metal).get(), new Item.Properties()))));
    public static final Map<SimpleAFCFluid, RegistryObject<BucketItem>> SIMPLE_AFC_FLUID_BUCKETS = Helpers.mapOfKeys(SimpleAFCFluid.class, fluid -> AFCItems.register("bucket/" + fluid.m_7912_(), () -> new BucketItem((Supplier)AFCFluids.SIMPLE_AFC_FLUIDS.get(fluid).source(), new Item.Properties())));
    public static final RegistryObject<Item> RUBBER_BAR = AFCItems.register("rubber_bar");
    public static final RegistryObject<Item> MAPLE_SUGAR = AFCItems.register("maple_sugar");
    public static final RegistryObject<Item> BIRCH_SUGAR = AFCItems.register("birch_sugar");

    private static RegistryObject<Item> register(String name) {
        return AFCItems.register(name, () -> new Item(new Item.Properties()));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), item);
    }
}

