/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.blockentities;

import com.therighthon.afc.common.blockentities.AFCHangingSignBlockEntity;
import com.therighthon.afc.common.blockentities.AFCSignBlockEntity;
import com.therighthon.afc.common.blockentities.TapBlockEntity;
import com.therighthon.afc.common.blocks.AFCBlocks;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AFCBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"afc");
    public static final RegistryObject<BlockEntityType<TapBlockEntity>> TAP_BLOCK_ENTITY = AFCBlockEntities.register("tap_block_entity", TapBlockEntity::new, AFCBlocks.TREE_TAP);
    public static final RegistryObject<BlockEntityType<AFCSignBlockEntity>> SIGN = AFCBlockEntities.register("sign", AFCSignBlockEntity::new, Stream.concat(AFCBlockEntities.afcWoodBlocks(Wood.BlockType.SIGN), AFCBlockEntities.afcWoodBlocks(Wood.BlockType.WALL_SIGN)));
    public static final RegistryObject<BlockEntityType<AFCHangingSignBlockEntity>> HANGING_SIGN = AFCBlockEntities.register("hanging_sign", AFCHangingSignBlockEntity::new, Stream.of(AFCBlocks.CEILING_HANGING_SIGNS, AFCBlocks.WALL_HANGING_SIGNS).flatMap(woodMap -> woodMap.values().stream().flatMap(metalMap -> metalMap.values().stream())));

    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> factory, Stream<? extends Supplier<? extends Block>> blocks) {
        return RegistrationHelpers.register(BLOCK_ENTITIES, (String)name, factory, blocks);
    }

    public static void register(IEventBus eventBus) {
        BLOCK_ENTITIES.register(eventBus);
    }

    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> block) {
        return RegistrationHelpers.register(BLOCK_ENTITIES, (String)name, factory, block);
    }

    private static Stream<? extends Supplier<? extends Block>> afcWoodBlocks(Wood.BlockType type) {
        return AFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get(type));
    }
}

