/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class MountainSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = MountainSurfaceBuilder::new;
    private final Noise2D surfaceMaterialNoise;
    private final Noise2D heightNoise;

    public MountainSurfaceBuilder(long seed) {
        this.surfaceMaterialNoise = new OpenSimplex2D(seed).octaves(2).spread(0.02f);
        this.heightNoise = new OpenSimplex2D(seed + 71829341L).octaves(2).spread(0.1f);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        NormalSurfaceBuilder surfaceBuilder = NormalSurfaceBuilder.ROCKY;
        double heightNoise = this.heightNoise.noise(context.pos().m_123341_(), context.pos().m_123343_()) * 4.0 + (double)startY;
        if (heightNoise > 130.0) {
            double surfaceMaterialValue = this.surfaceMaterialNoise.noise(context.pos().m_123341_(), context.pos().m_123343_()) + (double)(0.1f * context.random().m_188501_()) - (double)0.05f;
            if (surfaceMaterialValue > (double)0.3f) {
                surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.COBBLE, SurfaceStates.COBBLE, SurfaceStates.RAW);
            } else if (surfaceMaterialValue < (double)-0.3f) {
                surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.GRAVEL, SurfaceStates.GRAVEL, SurfaceStates.RAW);
            } else {
                surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.RAW, SurfaceStates.RAW, SurfaceStates.RAW);
            }
        } else {
            surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.GRASS, SurfaceStates.DIRT, SurfaceStates.SANDSTONE_OR_GRAVEL);
        }
    }
}

