/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import com.google.common.base.Preconditions;
import net.dries007.tfc.world.river.Flow;
import net.dries007.tfc.world.river.RiverHelpers;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class MidpointFractal {
    private static final double JITTER_MAX = (double)0.2f;
    private static final double JITTER_MIN = (double)0.05f;
    private static final int MAX_BISECTIONS = 10;
    private static final double[] ENCOMPASSING_RANGES = new double[10];
    public final double[] segments;
    private final double norm;

    private static double[] bisect(RandomSource random, int bisections, double[] segments) {
        for (int i = 0; i < bisections; ++i) {
            double[] splitSegments = new double[(segments.length << 1) - 2];
            splitSegments[0] = segments[0];
            splitSegments[1] = segments[1];
            int splitIndex = 2;
            for (int index = 0; index < segments.length - 2; index += 2) {
                double sourceX = segments[index];
                double sourceY = segments[index + 1];
                double drainX = segments[index + 2];
                double drainY = segments[index + 3];
                double norm = RiverHelpers.normInf(sourceX - drainX, sourceY - drainY);
                double bisectX = MidpointFractal.randomJitter(random) * norm + (sourceX + drainX) * 0.5;
                double bisectY = MidpointFractal.randomJitter(random) * norm + (sourceY + drainY) * 0.5;
                splitSegments[splitIndex] = bisectX;
                splitSegments[splitIndex + 1] = bisectY;
                splitSegments[splitIndex + 2] = drainX;
                splitSegments[splitIndex + 3] = drainY;
                splitIndex += 4;
            }
            segments = splitSegments;
        }
        return segments;
    }

    private static double randomJitter(RandomSource random) {
        double value;
        return 0.15000000223517418 * value + ((value = 2.0 * random.m_188500_() - 1.0) < 0.0 ? (double)-0.05f : (double)0.05f);
    }

    public MidpointFractal(RandomSource random, int bisections, double sourceX, double sourceY, double drainX, double drainY) {
        Preconditions.checkArgument((bisections >= 0 && bisections < 10 ? 1 : 0) != 0, (Object)"Bisections must be within [0, MAX_BISECTIONS)");
        this.segments = MidpointFractal.bisect(random, bisections, new double[]{sourceX, sourceY, drainX, drainY});
        this.norm = ENCOMPASSING_RANGES[bisections] * RiverHelpers.normInf(sourceX - drainX, sourceY - drainY);
    }

    public boolean maybeIntersect(double x, double y, double distance) {
        double t;
        double d = RiverHelpers.distancePointToLineSq(this.segments[0], this.segments[1], this.segments[this.segments.length - 2], this.segments[this.segments.length - 1], x, y);
        return d <= (t = distance + this.norm) * t;
    }

    public boolean intersect(double x, double y, double distance) {
        return this.maybeIntersect(x, y, distance) && this.intersectIndex(x, y, distance * distance) != -1;
    }

    public double intersectDistance(double x, double y) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.segments.length - 2; i += 2) {
            double d = RiverHelpers.distancePointToLineSq(this.segments[i], this.segments[i + 1], this.segments[i + 2], this.segments[i + 3], x, y);
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public Flow calculateFlow(double x, double y) {
        double min = Double.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < this.segments.length - 2; i += 2) {
            double d = RiverHelpers.distancePointToLineSq(this.segments[i], this.segments[i + 1], this.segments[i + 2], this.segments[i + 3], x, y);
            if (!(d < min)) continue;
            min = d;
            minIndex = i;
        }
        double sourceX = this.segments[minIndex];
        double sourceY = this.segments[minIndex + 1];
        double drainX = this.segments[minIndex + 2];
        double drainY = this.segments[minIndex + 3];
        double angle = Mth.m_14136_((double)(-(drainY - sourceY)), (double)(drainX - sourceX));
        return Flow.fromAngle(angle);
    }

    private int intersectIndex(double x, double y, double distSq) {
        for (int i = 0; i < this.segments.length - 2; i += 2) {
            double d = RiverHelpers.distancePointToLineSq(this.segments[i], this.segments[i + 1], this.segments[i + 2], this.segments[i + 3], x, y);
            if (!(d < distSq)) continue;
            return i;
        }
        return -1;
    }

    static {
        double sqrt2 = Math.sqrt(2.0);
        double delta = 0.0;
        double midpointDelta = 0.0;
        double norm = 1.0;
        for (int i = 0; i < 10; ++i) {
            MidpointFractal.ENCOMPASSING_RANGES[i] = Math.max(delta, midpointDelta);
            double prevMidpoint = midpointDelta;
            midpointDelta = 0.5 * (delta + midpointDelta) + sqrt2 * (double)0.2f * norm;
            delta = Math.max(prevMidpoint, delta);
            norm *= 0.7000000029802322;
        }
    }
}

