/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum ChooseRocks implements RegionTask
{
    INSTANCE;

    public static final int OCEAN = 0;
    public static final int VOLCANIC = 1;
    public static final int LAND = 2;
    public static final int UPLIFT = 3;
    public static final int TYPE_BITS = 2;
    public static final int TYPE_MASK = 3;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        Area rockArea = context.generator().rockArea.get();
        for (int dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                int index = dx + region.sizeX() * dz;
                Region.Point point = region.data()[index];
                if (point == null) continue;
                point.rock = rockArea.get(region.minX() + dx, region.minZ() + dz) << 2 | this.findClosestType(region, point, index);
            }
        }
    }

    private int findClosestType(Region region, Region.Point center, int index) {
        int type = center.land() ? 2 : 0;
        int minDist = Integer.MAX_VALUE;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = 0; dz <= 2; ++dz) {
                Region.Point point;
                int offset = region.offset(index, dx, dz);
                int dist = Math.abs(dx) + Math.abs(dz);
                if (offset == -1 || dist >= minDist || (point = region.data()[offset]) == null) continue;
                if (point.island() && dist < 4) {
                    type = 1;
                    minDist = dist;
                    continue;
                }
                if (!point.mountain() && !point.coastalMountain() || dist >= 3) continue;
                type = 3;
                minDist = dist;
            }
        }
        return type;
    }
}

