/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum AnnotateDistanceToOcean implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        BitSet explored = new BitSet(region.sizeX() * region.sizeZ());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        for (int dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                int index = dx + region.sizeX() * dz;
                Region.Point point = region.data()[index];
                if (point == null || point.land()) continue;
                point.distanceToOcean = (byte)-1;
                queue.enqueue(index);
                explored.set(index);
            }
        }
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.data()[last];
            int nextDistance = lastPoint.distanceToOcean + 1;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int next = region.offset(last, dx, dz);
                    if (next == -1) continue;
                    Region.Point point = region.data()[next];
                    if (point != null && point.land() && point.distanceToOcean == 0) {
                        if (!lastPoint.land() && !point.island()) {
                            lastPoint.setShore();
                        }
                        if (!explored.get(next)) {
                            point.distanceToOcean = (byte)nextDistance;
                            queue.enqueue(next);
                        }
                    }
                    explored.set(next);
                }
            }
        }
    }
}

