/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.minecraft.util.Mth;

public final class AnnotateClimate
extends Enum<AnnotateClimate>
implements RegionTask {
    public static final /* enum */ AnnotateClimate INSTANCE = new AnnotateClimate();
    private static final /* synthetic */ AnnotateClimate[] $VALUES;

    public static AnnotateClimate[] values() {
        return (AnnotateClimate[])$VALUES.clone();
    }

    public static AnnotateClimate valueOf(String name) {
        return Enum.valueOf(AnnotateClimate.class, name);
    }

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        for (int x = region.minX(); x <= region.maxX(); ++x) {
            for (int z = region.minZ(); z <= region.maxZ(); ++z) {
                float bias;
                Region.Point point = region.maybeAt(x, z);
                if (point == null) continue;
                point.temperature = (float)context.generator().temperatureNoise.noise(x, z);
                point.rainfall = (float)context.generator().rainfallNoise.noise(x, z);
                if (point.land()) {
                    assert (point.distanceToOcean >= 0);
                    float potentialBias = Mth.m_184631_((float)point.distanceToEdge, (float)2.0f, (float)6.0f, (float)0.0f, (float)1.0f);
                    float oceanProximityBias = Mth.m_184631_((float)point.distanceToOcean, (float)2.0f, (float)6.0f, (float)0.0f, (float)1.0f);
                    bias = Math.min(potentialBias, oceanProximityBias);
                } else {
                    bias = 0.0f;
                }
                float biasTargetTemperature = Mth.m_14179_((float)bias, (float)5.0f, (float)point.temperature);
                float biasTargetRainfall = Mth.m_14179_((float)bias, (float)Math.min(point.rainfall + 350.0f, 500.0f), (float)point.rainfall);
                point.temperature = Mth.m_14179_((float)0.23f, (float)point.temperature, (float)biasTargetTemperature);
                point.rainfall = Mth.m_14179_((float)0.23f, (float)point.rainfall, (float)biasTargetRainfall);
            }
        }
    }

    private static /* synthetic */ AnnotateClimate[] $values() {
        return new AnnotateClimate[]{INSTANCE};
    }

    static {
        $VALUES = AnnotateClimate.$values();
    }
}

