/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.minecraft.util.RandomSource;

public enum AnnotateBaseLandHeight implements RegionTask
{
    INSTANCE;

    private static final int ISLAND_SEED_DEPTH = 3;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        BitSet explored = new BitSet(region.sizeX() * region.sizeZ());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        IntArrayList islandQueue = new IntArrayList();
        RandomSource random = context.random;
        for (int dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                int index = dx + region.sizeX() * dz;
                Region.Point point = region.data()[index];
                if (point == null || !point.land()) continue;
                point.baseLandHeight = point.distanceToOcean;
                if (point.baseLandHeight > point.distanceToEdge) {
                    point.baseLandHeight = (byte)(0.3f * (float)point.baseLandHeight + 0.7f * (float)point.distanceToEdge);
                }
                explored.set(index);
                if (point.island()) {
                    point.baseOceanDepth = (byte)3;
                    islandQueue.add(index);
                    continue;
                }
                point.baseOceanDepth = 0;
                queue.enqueue(index);
            }
        }
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.data()[last];
            int nextDepth = lastPoint.baseOceanDepth + 1;
            if (nextDepth == 3 && !islandQueue.isEmpty()) {
                islandQueue.forEach(arg_0 -> ((IntArrayFIFOQueue)queue).enqueue(arg_0));
                islandQueue.clear();
            }
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int next = region.offset(last, dx, dz);
                    if (next == -1) continue;
                    Region.Point point = region.data()[next];
                    if (point != null && !point.land() && point.baseOceanDepth == 0 && !explored.get(next)) {
                        if (random.m_188503_(15) == 0) {
                            point.baseOceanDepth = lastPoint.baseOceanDepth;
                            queue.enqueueFirst(next);
                        } else {
                            point.baseOceanDepth = (byte)nextDepth;
                            queue.enqueue(next);
                        }
                    }
                    explored.set(next);
                }
            }
        }
    }
}

