/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import java.util.function.IntPredicate;
import java.util.function.Predicate;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.AdjacentTransformLayer;
import net.dries007.tfc.world.layer.framework.AreaContext;

public enum RegionEdgeBiomeLayer implements AdjacentTransformLayer
{
    INSTANCE;


    @Override
    public int apply(AreaContext context, int north, int east, int south, int west, int center) {
        Predicate<IntPredicate> matcher = p -> p.test(north) || p.test(east) || p.test(south) || p.test(west);
        if (TFCLayers.isLow(center)) {
            if (matcher.test(TFCLayers::isOcean) && matcher.test(TFCLayers::isMountains)) {
                return TFCLayers.OCEANIC_MOUNTAINS;
            }
            if (matcher.test(TFCLayers::isOcean) && matcher.test(i -> i == TFCLayers.LOWLANDS)) {
                return TFCLayers.SALT_MARSH;
            }
        }
        if (center == TFCLayers.PLATEAU || center == TFCLayers.BADLANDS || center == TFCLayers.INVERTED_BADLANDS) {
            if (matcher.test(i -> i == TFCLayers.LOW_CANYONS || i == TFCLayers.LOWLANDS)) {
                return TFCLayers.HILLS;
            }
            if (matcher.test(i -> i == TFCLayers.PLAINS || i == TFCLayers.HILLS)) {
                return TFCLayers.ROLLING_HILLS;
            }
        } else if (TFCLayers.isMountains(center)) {
            if (matcher.test(TFCLayers::isLow)) {
                return TFCLayers.ROLLING_HILLS;
            }
        } else if (center == TFCLayers.LOWLANDS || center == TFCLayers.LOW_CANYONS) {
            if (matcher.test(i -> i == TFCLayers.PLATEAU || i == TFCLayers.BADLANDS || i == TFCLayers.INVERTED_BADLANDS)) {
                return TFCLayers.HILLS;
            }
            if (matcher.test(TFCLayers::isMountains)) {
                return TFCLayers.ROLLING_HILLS;
            }
        } else if (center == TFCLayers.PLAINS || center == TFCLayers.HILLS) {
            if (matcher.test(i -> i == TFCLayers.PLATEAU || i == TFCLayers.BADLANDS || i == TFCLayers.INVERTED_BADLANDS)) {
                return TFCLayers.HILLS;
            }
            if (matcher.test(TFCLayers::isMountains)) {
                return TFCLayers.ROLLING_HILLS;
            }
        } else if (center == TFCLayers.DEEP_OCEAN_TRENCH && matcher.test(i -> !TFCLayers.isOcean(i))) {
            return TFCLayers.OCEAN;
        }
        return center;
    }
}

