/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.feature.vein.DiscVeinConfig;
import net.dries007.tfc.world.feature.vein.IVein;
import net.dries007.tfc.world.feature.vein.VeinFeature;
import net.dries007.tfc.world.noise.Metaballs2D;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class DiscVeinFeature
extends VeinFeature<DiscVeinConfig, Vein> {
    public DiscVeinFeature(Codec<DiscVeinConfig> codec) {
        super(codec);
    }

    @Override
    protected float getChanceToGenerate(int x, int y, int z, Vein vein, DiscVeinConfig config) {
        float sample = (float)vein.metaballs.sample(x, z);
        if (Math.abs(y) <= config.height() && sample > 1.0f) {
            return config.config().density() * Mth.m_184631_((float)Math.abs(y - config.height()), (float)(0.7f * (float)config.height()), (float)config.height(), (float)1.0f, (float)0.4f) * Mth.m_184631_((float)sample, (float)2.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        }
        return 0.0f;
    }

    @Override
    protected Vein createVein(WorldGenerationContext context, int chunkX, int chunkZ, RandomSource random, DiscVeinConfig config) {
        return new Vein(this.defaultPosRespectingHeight(chunkX, chunkZ, random, config), Metaballs2D.simple(random, config.size()));
    }

    private BlockPos defaultPosRespectingHeight(int chunkX, int chunkZ, RandomSource random, DiscVeinConfig config) {
        return new BlockPos(chunkX + random.m_188503_(16), this.defaultYPos(config.size(), random, config), chunkZ + random.m_188503_(16));
    }

    @Override
    protected BoundingBox getBoundingBox(DiscVeinConfig config, Vein vein) {
        return new BoundingBox(-config.size(), -config.height(), -config.size(), config.size(), config.height(), config.size());
    }

    protected record Vein(BlockPos pos, Metaballs2D metaballs) implements IVein
    {
    }
}

