/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.dries007.tfc.world.Codecs;
import net.minecraft.util.StringRepresentable;

public record TreePlacementConfig(int width, int height, GroundType groundType) {
    public static final Codec<TreePlacementConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(c -> c.width), (App)Codec.INT.fieldOf("height").forGetter(c -> c.height), (App)Codecs.optionalFieldOf(GroundType.CODEC, "ground_type", GroundType.NORMAL).forGetter(c -> c.groundType)).apply((Applicative)instance, TreePlacementConfig::new));

    public boolean mayPlaceInWater() {
        return this.groundType == GroundType.SHALLOW_WATER || this.groundType == GroundType.SUBMERGED || this.groundType == GroundType.SUBMERGED_ALLOW_SALTWATER;
    }

    public boolean mayPlaceUnderwater() {
        return this.groundType == GroundType.SUBMERGED || this.groundType == GroundType.SUBMERGED_ALLOW_SALTWATER;
    }

    public boolean requiresFreshwater() {
        return this.groundType != GroundType.SUBMERGED_ALLOW_SALTWATER && this.groundType != GroundType.SHALLOW_ALLOW_SALTWATER;
    }

    public static enum GroundType implements StringRepresentable
    {
        NORMAL,
        SAND,
        SHALLOW_WATER,
        SUBMERGED,
        SHALLOW_ALLOW_SALTWATER,
        SUBMERGED_ALLOW_SALTWATER,
        FLOATING;

        public static final Codec<GroundType> CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.m_216439_(GroundType::values);
        }
    }
}

