/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.feature.tree.RootConfig;
import net.dries007.tfc.world.feature.tree.TreePlacementConfig;
import net.dries007.tfc.world.feature.tree.TrunkConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public record StackedTreeConfig(List<Layer> layers, TrunkConfig trunk, TreePlacementConfig placement, Optional<RootConfig> rootSystem) implements FeatureConfiguration
{
    public static final Codec<StackedTreeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Layer.CODEC.listOf().fieldOf("layers").forGetter(c -> c.layers), (App)TrunkConfig.CODEC.fieldOf("trunk").forGetter(c -> c.trunk), (App)TreePlacementConfig.CODEC.fieldOf("placement").forGetter(c -> c.placement), (App)Codecs.optionalFieldOf(RootConfig.CODEC, "root_system").forGetter(c -> c.rootSystem)).apply((Applicative)instance, StackedTreeConfig::new));

    public record Layer(List<ResourceLocation> templates, int minCount, int maxCount) {
        public static final Codec<Layer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("templates").forGetter(c -> c.templates), (App)Codec.INT.fieldOf("min_count").forGetter(c -> c.minCount), (App)Codec.INT.fieldOf("max_count").forGetter(c -> c.maxCount)).apply((Applicative)instance, Layer::new)).comapFlatMap(c -> {
            if (c.maxCount < c.minCount) {
                return DataResult.error(() -> "max count (provided = " + c.maxCount + ") must be greater than min count (provided = " + c.minCount + ")");
            }
            return DataResult.success((Object)c);
        }, Function.identity());

        public int getCount(RandomSource random) {
            if (this.maxCount == this.minCount) {
                return this.minCount;
            }
            return this.minCount + random.m_188503_(1 + this.maxCount - this.minCount);
        }
    }
}

