/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import net.dries007.tfc.mixin.accessor.StructureTemplateAccessor;
import net.dries007.tfc.world.feature.tree.RandomTreeConfig;
import net.dries007.tfc.world.feature.tree.TreeHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class RandomTreeFeature
extends Feature<RandomTreeConfig> {
    public RandomTreeFeature(Codec<RandomTreeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RandomTreeConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        RandomTreeConfig config = (RandomTreeConfig)context.m_159778_();
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        StructureTemplateManager manager = TreeHelpers.getStructureManager(level);
        StructurePlaceSettings settings = TreeHelpers.getPlacementSettings((LevelHeightAccessor)level, chunkPos, random);
        ResourceLocation structureId = config.structureNames().get(random.m_188503_(config.structureNames().size()));
        StructureTemplate structure = manager.m_230359_(structureId);
        if (((StructureTemplateAccessor)structure).accessor$getPalettes().isEmpty()) {
            throw new IllegalStateException("Empty structure: " + structureId);
        }
        if (TreeHelpers.isValidLocation((LevelAccessor)level, pos, settings, config.placement())) {
            boolean placeTree = config.rootSystem().map(roots -> TreeHelpers.placeRoots(level, pos.m_7495_(), roots, random) || !roots.required()).orElse(true);
            if (placeTree) {
                config.trunk().ifPresent(trunk -> {
                    int height = TreeHelpers.placeTrunk(level, (BlockPos)mutablePos, random, settings, trunk);
                    mutablePos.m_122184_(0, height, 0);
                });
                TreeHelpers.placeTemplate(structure, settings, (ServerLevelAccessor)level, mutablePos.m_121996_((Vec3i)TreeHelpers.transformCenter(structure.m_163801_(), settings)));
                return true;
            }
            return false;
        }
        return false;
    }
}

