/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.GroundcoverBlockType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;

public class TidePoolFeature
extends Feature<NoneFeatureConfiguration> {
    public TidePoolFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos;
        boolean placedAny = false;
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        if (origin.m_123342_() > 67 || origin.m_123342_() < 62) {
            return false;
        }
        boolean hasRim = random.m_188500_() < 0.9;
        int rimOffsetX = hasRim ? Mth.m_216271_((RandomSource)random, (int)0, (int)2) : 0;
        int rimOffsetZ = hasRim ? Mth.m_216271_((RandomSource)random, (int)0, (int)2) : 0;
        boolean willPlaceRim = hasRim && rimOffsetX != 0 && rimOffsetZ != 0;
        int xSize = Mth.m_216271_((RandomSource)random, (int)3, (int)7);
        int zSize = Mth.m_216271_((RandomSource)random, (int)3, (int)7);
        int maxLength = Math.max(xSize, zSize);
        ChunkDataProvider provider = ChunkDataProvider.get(context.m_159775_());
        RockSettings rock = provider.get(context.m_159774_(), origin).getRockData().getRock(origin);
        BlockState cobble = rock.cobble().m_49966_();
        BlockState raw = rock.raw().m_49966_();
        BlockState water = ((LiquidBlock)TFCBlocks.SALT_WATER.get()).m_49966_();
        Predicate<BlockState> test = state -> state.m_60734_() == cobble.m_60734_() || !state.m_60819_().m_76178_();
        Iterator iterator = BlockPos.m_121925_((BlockPos)origin, (int)xSize, (int)0, (int)zSize).iterator();
        while (iterator.hasNext() && (pos = (BlockPos)iterator.next()).m_123333_((Vec3i)origin) <= maxLength) {
            BlockPos offsetPos;
            if (!TidePoolFeature.isClear((LevelAccessor)level, pos, test)) continue;
            if (willPlaceRim) {
                placedAny = true;
                this.m_5974_((LevelWriter)level, pos, raw);
                if (random.m_188501_() < 0.01f && level.m_8055_(pos.m_7494_()).m_60795_()) {
                    this.m_5974_((LevelWriter)level, pos.m_7494_(), ((Block)TFCBlocks.GROUNDCOVER.get((Object)GroundcoverBlockType.GUANO).get()).m_49966_());
                }
            }
            if (!TidePoolFeature.isClear((LevelAccessor)level, offsetPos = pos.m_7918_(rimOffsetX, 0, rimOffsetZ), test)) continue;
            placedAny = true;
            BlockState toPlace = cobble;
            if (random.m_188499_()) {
                toPlace = water;
                if (random.m_188501_() < 0.15f) {
                    BlockState groundcover = Helpers.randomBlock(TFCTags.Blocks.TIDE_POOL_BLOCKS, random).map(Block::m_49966_).orElse(water);
                    if ((groundcover = FluidHelpers.fillWithFluid(groundcover, (Fluid)TFCFluids.SALT_WATER.getSource())) != null) {
                        toPlace = groundcover;
                    }
                }
            }
            this.m_5974_((LevelWriter)level, offsetPos, toPlace);
        }
        return placedAny;
    }

    private static boolean isClear(LevelAccessor level, BlockPos pos, Predicate<BlockState> contentsTest) {
        if (contentsTest.test(level.m_8055_(pos))) {
            return false;
        }
        for (Direction direction : Helpers.DIRECTIONS) {
            boolean airAbove = level.m_8055_(pos.m_121945_(direction)).m_60795_();
            if ((!airAbove || direction == Direction.UP) && (airAbove || direction != Direction.UP)) continue;
            return false;
        }
        return true;
    }
}

