/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public class LooseRockFeature
extends Feature<NoneFeatureConfiguration> {
    public LooseRockFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        ChunkDataProvider provider = ChunkDataProvider.get(context.m_159775_());
        ChunkData data = provider.get(level, pos);
        RockSettings rock = data.getRockData().getRock(pos);
        @Nullable Block looseRock = rock.loose().orElse(null);
        @Nullable Block mossyLooseRock = rock.mossyLoose().orElse(null);
        if (looseRock == null) {
            return false;
        }
        BlockState stateAt = level.m_8055_(pos);
        BlockState rockState = mossyLooseRock != null && data.getRainfall(pos) > 250.0f && random.m_188499_() && stateAt.m_60819_().m_76178_() ? FluidHelpers.fillWithFluid(mossyLooseRock.m_49966_(), stateAt.m_60819_().m_76152_()) : FluidHelpers.fillWithFluid(looseRock.m_49966_(), stateAt.m_60819_().m_76152_());
        if (rockState != null && EnvironmentHelpers.isWorldgenReplaceable(stateAt) && rockState.m_60710_((LevelReader)level, pos) && this.canGenerateOn(level.m_8055_(pos.m_7495_()))) {
            this.m_5974_((LevelWriter)level, pos, (BlockState)rockState.m_61124_((Property)TFCBlockStateProperties.COUNT_1_3, (Comparable)Integer.valueOf(1 + random.m_188503_(2))));
            return true;
        }
        return false;
    }

    private boolean canGenerateOn(BlockState state) {
        return !Helpers.isBlock(state, (TagKey<Block>)BlockTags.f_13047_);
    }
}

