/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.TFCChunkGenerator;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class DynamicDensityRandomPatchFeature
extends Feature<RandomPatchConfiguration> {
    public DynamicDensityRandomPatchFeature(Codec<RandomPatchConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RandomPatchConfiguration> context) {
        RandomPatchConfiguration config = (RandomPatchConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        int placed = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int width = config.f_191302_() + 1;
        int height = config.f_191303_() + 1;
        int tries = this.getTries(context, level, pos, config.f_67907_());
        for (int i = 0; i < tries; ++i) {
            mutablePos.m_122154_((Vec3i)pos, random.m_188503_(width) - random.m_188503_(width), random.m_188503_(height) - random.m_188503_(height), random.m_188503_(width) - random.m_188503_(width));
            if (!((PlacedFeature)config.f_191304_().m_203334_()).m_226357_(level, context.m_159775_(), random, (BlockPos)mutablePos)) continue;
            ++placed;
        }
        return placed > 0;
    }

    private int getTries(FeaturePlaceContext<RandomPatchConfiguration> context, WorldGenLevel level, BlockPos pos, int tries) {
        ChunkDataProvider provider = ChunkDataProvider.get(context.m_159775_());
        ChunkData data = provider.get(level, pos);
        ForestType forestType = data.getForestType();
        int seaLevel = context.m_159775_().m_6337_();
        if (pos.m_123342_() > seaLevel + 25) {
            tries = (int)((float)tries * (1.0f - Mth.m_184631_((float)pos.m_123342_(), (float)(seaLevel + 25), (float)(seaLevel + 100), (float)0.0f, (float)0.8f)));
        }
        if (forestType == ForestType.OLD_GROWTH) {
            tries = Math.min(tries, 8);
        } else if (forestType == ForestType.NORMAL) {
            tries = Math.min(tries, 14);
        } else if (forestType == ForestType.EDGE) {
            tries = Math.min(tries, 40);
        }
        ChunkGenerator chunkGenerator = context.m_159775_();
        if (chunkGenerator instanceof TFCChunkGenerator) {
            TFCChunkGenerator generator = (TFCChunkGenerator)chunkGenerator;
            tries = (int)((float)tries * (generator.settings().grassDensity() * 2.0f));
        }
        return tries;
    }
}

