/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import org.jetbrains.annotations.Nullable;

public final class ChunkDataProvider {
    private final ChunkDataGenerator generator;
    private final Map<ProtoChunk, ChunkData> partialChunkData;

    public static ChunkDataProvider get(WorldGenLevel level) {
        return ChunkDataProvider.get(((ServerChunkCache)level.m_7726_()).m_8481_());
    }

    public static ChunkDataProvider get(ChunkGenerator chunkGenerator) {
        if (chunkGenerator instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension extension = (ChunkGeneratorExtension)chunkGenerator;
            return extension.chunkDataProvider();
        }
        throw new IllegalStateException("Tried to access ChunkDataProvider but none was present on " + chunkGenerator);
    }

    public ChunkDataProvider(ChunkDataGenerator generator) {
        this.generator = generator;
        this.partialChunkData = new MapMaker().weakKeys().concurrencyLevel(4).makeMap();
    }

    public ChunkDataGenerator generator() {
        return this.generator;
    }

    public ChunkData get(WorldGenLevel level, BlockPos pos) {
        return this.get(level.m_46865_(pos));
    }

    public ChunkData get(WorldGenLevel level, ChunkPos pos) {
        return this.get(level.m_6325_(pos.f_45578_, pos.f_45579_));
    }

    public ChunkData get(ChunkAccess chunk) {
        if (chunk instanceof ImposterProtoChunk) {
            ImposterProtoChunk imposter = (ImposterProtoChunk)chunk;
            return ChunkData.get(imposter.m_62768_());
        }
        if (chunk instanceof ProtoChunk) {
            ProtoChunk proto = (ProtoChunk)chunk;
            ChunkData data = this.partialChunkData.computeIfAbsent(proto, c -> new ChunkData(this.generator, c.m_7697_()));
            if (data.status() == ChunkData.Status.EMPTY) {
                this.generator.generate(data);
            }
            return data;
        }
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            return ChunkData.get(levelChunk);
        }
        throw new IllegalStateException("Cannot get chunk data from an unknown chunk: " + chunk.getClass() + " at " + chunk.m_7697_());
    }

    @Deprecated(forRemoval=true)
    public ChunkData get(ChunkPos pos) {
        return this.createAndGeneratePartial(pos);
    }

    public ChunkData createAndGeneratePartial(ChunkPos pos) {
        ChunkData data = new ChunkData(this.generator, pos);
        this.generator.generate(data);
        return data;
    }

    public void loadPartial(ProtoChunk chunk, CompoundTag nbt) {
        this.partialChunkData.computeIfAbsent(chunk, c -> new ChunkData(this.generator, c.m_7697_())).deserializeNBT(nbt);
    }

    @Nullable
    public CompoundTag savePartial(ProtoChunk chunk) {
        ChunkData data = this.partialChunkData.get(chunk);
        return data == null ? null : data.serializeNBT();
    }

    public void promotePartial(ProtoChunk protoChunk, LevelChunk levelChunk) {
        ChunkData.update(levelChunk, this.partialChunkData.remove(protoChunk));
    }

    public ChunkData create(ChunkPos pos) {
        return new ChunkData(this.generator, pos);
    }

    public String toString() {
        return "ChunkDataProvider[" + this.generator.getClass().getSimpleName() + "]";
    }
}

