/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public final class VolcanoNoise {
    private final Cellular2D cellNoise;
    private final Noise2D jitterNoise;

    private static float calculateEasing(float f1) {
        return Mth.m_184637_((float)f1, (float)0.0f, (float)0.23f, (float)1.0f, (float)0.0f);
    }

    private static float calculateClampedEasing(float f1) {
        return Mth.m_14036_((float)VolcanoNoise.calculateEasing(f1), (float)0.0f, (float)1.0f);
    }

    private static float calculateShape(float t) {
        if (t > 0.025f) {
            return (5.0f / (9.0f * t + 1.0f) - 0.5f) * 0.27917364f;
        }
        float a = t * 9.0f + 0.05f;
        return (8.0f * a * a + 2.9766326f) * 0.27917364f;
    }

    public VolcanoNoise(long seed) {
        this.cellNoise = new Cellular2D(seed).spread(0.009f);
        this.jitterNoise = new OpenSimplex2D(seed + 1234123L).octaves(2).scaled(-0.0016f, 0.0016f).spread(0.128f);
    }

    public double modifyHeight(double x, double z, double baseHeight, int rarity, int baseVolcanoHeight, int scaleVolcanoHeight) {
        Cellular2D.Cell cell = this.sampleCell(x, z, rarity);
        if (cell != null) {
            float easing = Mth.m_14036_((float)(VolcanoNoise.calculateEasing((float)cell.f1()) + (float)this.jitterNoise.noise(x, z)), (float)0.0f, (float)1.0f);
            float shape = VolcanoNoise.calculateShape(1.0f - easing);
            float volcanoHeight = (float)(63 + baseVolcanoHeight) + shape * (float)scaleVolcanoHeight;
            float volcanoAdditionalHeight = shape * (float)scaleVolcanoHeight;
            return Mth.m_14139_((double)easing, (double)baseHeight, (double)(0.5 * ((double)volcanoHeight + Math.max((double)volcanoHeight, baseHeight + (double)(0.4f * volcanoAdditionalHeight)))));
        }
        return baseHeight;
    }

    public float calculateEasing(int x, int z, int rarity) {
        Cellular2D.Cell cell = this.sampleCell(x, z, rarity);
        if (cell != null) {
            return VolcanoNoise.calculateClampedEasing((float)cell.f1());
        }
        return 0.0f;
    }

    @Nullable
    public BlockPos calculateCenter(int x, int y, int z, int rarity) {
        Cellular2D.Cell cell = this.sampleCell(x, z, rarity);
        if (cell != null) {
            return new BlockPos((int)cell.x(), y, (int)cell.y());
        }
        return null;
    }

    @Nullable
    private Cellular2D.Cell sampleCell(double x, double z, int rarity) {
        Cellular2D.Cell cell = this.cellNoise.cell(x, z);
        if (Math.abs(cell.noise()) <= (double)(1.0f / (float)rarity)) {
            return cell;
        }
        return null;
    }
}

