/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.world.Sampler;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.chunkdata.RockData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ChunkBaseBlockSource {
    private final RockData rockData;
    private final Sampler<BiomeExtension> biomeSampler;
    private final BlockState[] cachedFluidStates;
    private final BlockState freshWater = Blocks.f_49990_.m_49966_();
    private final BlockState saltWater = ((LiquidBlock)TFCBlocks.SALT_WATER.get()).m_49966_();

    private static int index(int x, int z) {
        return x & 0xF | (z & 0xF) << 4;
    }

    public ChunkBaseBlockSource(RockData rockData, Sampler<BiomeExtension> biomeSampler) {
        this.rockData = rockData;
        this.biomeSampler = biomeSampler;
        this.cachedFluidStates = new BlockState[256];
    }

    public void useAccurateBiome(int localX, int localZ, BiomeExtension biome) {
        this.cachedFluidStates[ChunkBaseBlockSource.index((int)localX, (int)localZ)] = biome.isSalty() ? this.saltWater : this.freshWater;
    }

    public BlockState getBaseBlock(int blockX, int blockY, int blockZ) {
        return this.rockData.getRock(blockX, blockY, blockZ).raw().m_49966_();
    }

    public BlockState modifyFluid(BlockState fluidOrAir, int x, int z) {
        if (fluidOrAir == this.freshWater) {
            int index = ChunkBaseBlockSource.index(x, z);
            BlockState state = this.cachedFluidStates[index];
            if (state == null) {
                this.cachedFluidStates[index] = state = this.biomeSampler.get(x, z).isSalty() ? this.saltWater : this.freshWater;
            }
            return state;
        }
        return fluidOrAir;
    }
}

