/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

public enum KoppenClimateClassification {
    ARCTIC,
    TUNDRA,
    SUBARCTIC,
    COLD_DESERT,
    HOT_DESERT,
    TEMPERATE,
    SUBTROPICAL,
    HUMID_SUBTROPICAL,
    HUMID_OCEANIC,
    HUMID_SUBARCTIC,
    TROPICAL_SAVANNA,
    TROPICAL_RAINFOREST;


    public static KoppenClimateClassification classify(float averageTemperature, float rainfall) {
        if (averageTemperature < -20.0f) {
            return ARCTIC;
        }
        if (rainfall < 150.0f) {
            if (averageTemperature > 4.0f) {
                return HOT_DESERT;
            }
            return COLD_DESERT;
        }
        if (averageTemperature < -14.0f) {
            if (rainfall > 300.0f) {
                return SUBARCTIC;
            }
            return TUNDRA;
        }
        if (averageTemperature > 18.0f) {
            if (rainfall > 300.0f) {
                return TROPICAL_RAINFOREST;
            }
            return TROPICAL_SAVANNA;
        }
        if (rainfall > 350.0f) {
            if (averageTemperature > 12.0f) {
                return HUMID_SUBTROPICAL;
            }
            if (averageTemperature > -5.0f) {
                return HUMID_OCEANIC;
            }
            return HUMID_SUBARCTIC;
        }
        if (averageTemperature > 12.0f) {
            return SUBTROPICAL;
        }
        if (averageTemperature > -5.0f) {
            return TEMPERATE;
        }
        return SUBARCTIC;
    }
}

