/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.PhysicalDamageTypeData;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class ItemDamageResistance
extends PhysicalDamageTypeData {
    public static final DataManager<ItemDamageResistance> MANAGER = new DataManager<ItemDamageResistance>(Helpers.identifier("item_damage_resistances"), "item_damage_resistances", ItemDamageResistance::new, ItemDamageResistance::new, ItemDamageResistance::encode, Packet::new);
    public static final IndirectHashCollection<Item, ItemDamageResistance> CACHE = IndirectHashCollection.create(ItemDamageResistance::getValidItems, MANAGER::getValues);
    private final Ingredient ingredient;

    @Nullable
    public static ItemDamageResistance get(ItemStack item) {
        for (ItemDamageResistance resist : CACHE.getAll(item.m_41720_())) {
            if (!resist.matches(item)) continue;
            return resist;
        }
        return null;
    }

    public ItemDamageResistance(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
    }

    public ItemDamageResistance(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        this.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        this.ingredient.m_43923_(buffer);
    }

    public boolean matches(ItemStack item) {
        return this.ingredient.test(item);
    }

    public Collection<Item> getValidItems() {
        return Arrays.stream(this.ingredient.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toSet());
    }

    public static class Packet
    extends DataManagerSyncPacket<ItemDamageResistance> {
    }
}

