/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record StackFoodPacket(int index) {
    StackFoodPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130242_());
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.index);
    }

    void handle(@Nullable ServerPlayer player) {
        block8: {
            InventoryMenu menu;
            block10: {
                block9: {
                    if (player == null) break block8;
                    AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                    if (!(abstractContainerMenu instanceof InventoryMenu)) break block9;
                    menu = (InventoryMenu)abstractContainerMenu;
                    if (this.index >= 0 && this.index < menu.f_38839_.size()) break block10;
                }
                return;
            }
            Slot targetSlot = menu.m_38853_(this.index);
            if (targetSlot instanceof ResultSlot) {
                return;
            }
            ItemStack targetStack = targetSlot.m_7993_();
            @Nullable IFood targetCap = FoodCapability.get(targetStack);
            if (targetCap == null || targetStack.m_41741_() == targetStack.m_41613_() || targetCap.isRotten()) {
                return;
            }
            List<Slot> stackableSlots = this.getStackableSlots(targetSlot, (List<Slot>)menu.f_38839_);
            int currentAmount = targetStack.m_41613_();
            int remaining = targetStack.m_41741_() - currentAmount;
            long minCreationDate = targetCap.getCreationDate();
            Iterator<Slot> slotIterator = stackableSlots.iterator();
            while (remaining > 0 && slotIterator.hasNext()) {
                Slot slot = slotIterator.next();
                ItemStack stack = slot.m_7993_();
                @Nullable IFood cap = FoodCapability.get(stack);
                if (cap == null || cap.isRotten()) continue;
                if (cap.getCreationDate() < minCreationDate) {
                    minCreationDate = cap.getCreationDate();
                }
                if (remaining < stack.m_41613_()) {
                    currentAmount += remaining;
                    stack.m_41774_(remaining);
                    remaining = 0;
                    continue;
                }
                currentAmount += stack.m_41613_();
                remaining -= stack.m_41613_();
                stack.m_41774_(stack.m_41613_());
            }
            targetStack.m_41764_(currentAmount);
            targetCap.setCreationDate(minCreationDate);
            menu.m_6199_((Container)menu.m_39730_());
        }
    }

    private List<Slot> getStackableSlots(Slot targetSlot, List<Slot> inventorySlots) {
        ArrayList<Slot> stackableSlots = new ArrayList<Slot>();
        for (Slot slot2 : inventorySlots) {
            if (slot2.getSlotIndex() == targetSlot.getSlotIndex() || slot2 instanceof ResultSlot) continue;
            ItemStack stack = slot2.m_7993_();
            if (!FoodCapability.areStacksStackableExceptCreationDate(targetSlot.m_7993_(), stack)) continue;
            stackableSlots.add(slot2);
        }
        stackableSlots.sort(Comparator.comparingInt(slot -> slot.m_7993_().m_41613_()));
        return stackableSlots;
    }
}

