/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SnowLayerBlock.class})
public abstract class SnowLayerBlockMixin
extends Block {
    private SnowLayerBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float m_49961_() {
        return (Boolean)TFCConfig.SERVER.enableSnowSlowEntities.get() != false ? 0.6f : 1.0f;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.m_5707_(level, pos, state, player);
        int prevLayers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
        if (prevLayers > 1 && !player.m_7500_()) {
            return level.m_7731_(pos, (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(prevLayers - 1)), level.f_46443_ ? 11 : 3);
        }
        return level.m_7731_(pos, fluid.m_76188_(), level.f_46443_ ? 11 : 3);
    }

    @Inject(method={"canSurvive"}, at={@At(value="RETURN")}, cancellable=true)
    private void canSurviveAddIceAndLeavesConditions(BlockState state, LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (cir.getReturnValueZ()) {
            if (Helpers.isBlock(belowState, (Block)TFCBlocks.SEA_ICE.get()) || Helpers.isBlock(belowState, (Block)TFCBlocks.ICE_PILE.get())) {
                cir.setReturnValue((Object)false);
            }
        } else {
            if (Helpers.isBlock(belowState, TFCTags.Blocks.SNOW_LAYER_SURVIVES_ON)) {
                cir.setReturnValue((Object)true);
            }
            if ((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) == 1 && belowState.m_60734_() instanceof ILeavesBlock) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"updateShape"}, at={@At(value="RETURN")}, cancellable=true)
    private void updateShapeSurviveOnLeavesWithSingleLayer(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> cir) {
        BlockState state;
        if (Helpers.isBlock((BlockState)cir.getReturnValue(), Blocks.f_50016_) && (Integer)stateIn.m_61143_((Property)SnowLayerBlock.f_56581_) > 1 && (state = (BlockState)stateIn.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(1))).m_60710_((LevelReader)level, currentPos)) {
            cir.setReturnValue((Object)state);
        }
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="HEAD")}, cancellable=true)
    private void getStateForPlacementOnSnowPile(BlockPlaceContext context, CallbackInfoReturnable<BlockState> cir) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (Helpers.isBlock(state, (Block)TFCBlocks.SNOW_PILE.get())) {
            cir.setReturnValue((Object)((BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(Math.min(8, (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) + 1)))));
        }
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void meltRarelyDueToTemperature(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (random.m_188503_(75) == 0 && Climate.getTemperature((Level)level, pos) > 2.0f) {
            SnowPileBlock.removePileOrSnow((LevelAccessor)level, pos, state);
            ci.cancel();
        }
    }
}

