/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.client.BarSystem;
import net.dries007.tfc.common.capabilities.forge.ForgingBonus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyForgingBonusToPreventItemDamage(int amount, RandomSource random, ServerPlayer player, CallbackInfoReturnable<Boolean> cir) {
        if (ForgingBonus.applyLikeUnbreaking((ItemStack)this, random)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isBarVisible"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject$isBarVisible(CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = (ItemStack)this;
        BarSystem.Bar bar = BarSystem.getCustomBar(stack);
        if (bar != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getBarColor"}, at={@At(value="TAIL")}, cancellable=true)
    private void inject$getBarColor(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        BarSystem.Bar bar = BarSystem.getCustomBar(stack);
        if (bar != null) {
            cir.setReturnValue((Object)bar.getBarColor(stack));
        }
    }

    @Inject(method={"getBarWidth"}, at={@At(value="TAIL")}, cancellable=true)
    private void inject$getBarWidth(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        BarSystem.Bar bar = BarSystem.getCustomBar(stack);
        if (bar != null) {
            cir.setReturnValue((Object)bar.getBarWidth(stack));
        }
    }
}

