/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.IBlockRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleBlockRecipe
implements IBlockRecipe {
    protected final ResourceLocation id;
    protected final BlockIngredient ingredient;
    protected final BlockState outputState;
    protected final boolean copyInputState;

    public SimpleBlockRecipe(ResourceLocation id, BlockIngredient ingredient, BlockState outputState, boolean copyInputState) {
        this.id = id;
        this.ingredient = ingredient;
        this.outputState = outputState;
        this.copyInputState = copyInputState;
    }

    @Override
    public boolean matches(BlockState state) {
        return this.ingredient.test(state);
    }

    @Override
    public BlockState getBlockCraftingResult(BlockState state) {
        return this.copyInputState ? state : this.outputState;
    }

    @Override
    public Block getBlockRecipeOutput() {
        return this.outputState.m_60734_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public BlockIngredient getBlockIngredient() {
        return this.ingredient;
    }

    public static class Serializer<R extends SimpleBlockRecipe>
    extends RecipeSerializerImpl<R> {
        private final Factory<R> factory;

        public Serializer(Factory<R> factory) {
            this.factory = factory;
        }

        public R fromJson(ResourceLocation recipeId, JsonObject json) {
            BlockIngredient ingredient = BlockIngredient.fromJson(JsonHelpers.get(json, "ingredient"));
            boolean copyInputState = GsonHelper.m_13855_((JsonObject)json, (String)"copy_input", (boolean)false);
            BlockState state = !copyInputState ? JsonHelpers.getBlockState(GsonHelper.m_13906_((JsonObject)json, (String)"result")) : Blocks.f_50016_.m_49966_();
            return this.factory.create(recipeId, ingredient, state, copyInputState);
        }

        @Nullable
        public R fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            BlockIngredient ingredient = BlockIngredient.fromNetwork(buffer);
            boolean copyInputState = buffer.readBoolean();
            BlockState state = copyInputState ? Blocks.f_50016_.m_49966_() : ((Block)BuiltInRegistries.f_256975_.m_7942_(buffer.m_130242_())).m_49966_();
            return this.factory.create(recipeId, ingredient, state, copyInputState);
        }

        public void toNetwork(FriendlyByteBuf buffer, R recipe) {
            ((SimpleBlockRecipe)recipe).ingredient.toNetwork(buffer);
            buffer.writeBoolean(((SimpleBlockRecipe)recipe).copyInputState);
            if (!((SimpleBlockRecipe)recipe).copyInputState) {
                buffer.m_130130_(BuiltInRegistries.f_256975_.m_7447_((Object)((SimpleBlockRecipe)recipe).outputState.m_60734_()));
            }
        }

        public static interface Factory<R extends SimpleBlockRecipe> {
            public R create(ResourceLocation var1, BlockIngredient var2, BlockState var3, boolean var4);
        }
    }
}

