/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Collectors;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class HeatingRecipe
implements ISimpleRecipe<ItemStackInventory> {
    public static final IndirectHashCollection<Item, HeatingRecipe> CACHE = IndirectHashCollection.createForRecipe(HeatingRecipe::getValidItems, TFCRecipeTypes.HEATING);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStackProvider outputItem;
    private final FluidStack outputFluid;
    private final float temperature;
    private final boolean useDurability;
    private final float chance;

    @Nullable
    public static HeatingRecipe getRecipe(ItemStack stack) {
        return HeatingRecipe.getRecipe(new ItemStackInventory(stack));
    }

    @Nullable
    public static HeatingRecipe getRecipe(ItemStackInventory wrapper) {
        for (HeatingRecipe recipe : CACHE.getAll(wrapper.getStack().m_41720_())) {
            if (!recipe.matches(wrapper, null)) continue;
            return recipe;
        }
        return null;
    }

    public HeatingRecipe(ResourceLocation id, Ingredient ingredient, ItemStackProvider outputItem, FluidStack outputFluid, float temperature, boolean useDurability, float chance) {
        this.id = id;
        this.ingredient = ingredient;
        this.outputItem = outputItem;
        this.outputFluid = outputFluid;
        this.temperature = temperature;
        this.useDurability = useDurability;
        this.chance = chance;
    }

    public boolean matches(ItemStackInventory inventory, @Nullable Level level) {
        return this.getIngredient().test(inventory.getStack());
    }

    public ItemStack m_8043_(@Nullable RegistryAccess registryAccess) {
        return this.outputItem.getEmptyStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.HEATING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.HEATING.get();
    }

    public ItemStack assemble(ItemStackInventory inventory, @Nullable RegistryAccess registryAccess) {
        ItemStack inputStack = inventory.getStack();
        ItemStack outputStack = this.outputItem.getSingleStack(inputStack);
        @Nullable IHeat inputHeat = HeatCapability.get(inputStack);
        if (inputHeat != null) {
            HeatCapability.setTemperature(outputStack, inputHeat.getTemperature());
        }
        if (!outputStack.m_41619_() && this.chance < 1.0f) {
            Random random = new Random();
            return random.nextFloat() < this.chance ? outputStack : ItemStack.f_41583_;
        }
        return outputStack;
    }

    public ItemStack assembleStacked(ItemStackInventory inventory, int stackSizeCap, float chance) {
        ItemStack inputStack = inventory.getStack();
        ItemStack outputStack = this.outputItem.getSingleStack(inputStack);
        @Nullable IHeat inputHeat = HeatCapability.get(inputStack);
        if (inputHeat != null) {
            HeatCapability.setTemperature(outputStack, inputHeat.getTemperature());
        }
        outputStack.m_41764_(Math.min(outputStack.m_41613_() * inputStack.m_41613_(), Math.min(outputStack.m_41741_(), stackSizeCap)));
        if (!outputStack.m_41619_() && chance < 1.0f) {
            Random random = new Random();
            int count = 0;
            for (int i = 0; i < outputStack.m_41613_(); ++i) {
                if (!(random.nextFloat() < chance)) continue;
                ++count;
            }
            outputStack.m_41764_(count);
            if (count == 0) {
                return ItemStack.f_41583_;
            }
        }
        return outputStack;
    }

    public FluidStack assembleFluid(ItemStackInventory inventory) {
        ItemStack inputStack = inventory.getStack();
        FluidStack outputFluid = this.outputFluid.copy();
        if (this.useDurability && !outputFluid.isEmpty() && inputStack.m_41776_() > 0 && inputStack.m_41763_()) {
            outputFluid.setAmount(Mth.m_14143_((float)((float)outputFluid.getAmount() * (1.0f - (float)inputStack.m_41773_() / (float)inputStack.m_41776_()))));
        }
        return outputFluid;
    }

    public FluidStack getDisplayOutputFluid() {
        return this.outputFluid;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public boolean isValidTemperature(float temperatureIn) {
        return temperatureIn >= this.temperature;
    }

    public Collection<Item> getValidItems() {
        return Arrays.stream(this.getIngredient().m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toSet());
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public float getChance() {
        return this.chance;
    }

    public static class Serializer
    extends RecipeSerializerImpl<HeatingRecipe> {
        public HeatingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            ItemStackProvider outputItem = json.has("result_item") ? ItemStackProvider.fromJson(json.getAsJsonObject("result_item")) : ItemStackProvider.empty();
            FluidStack outputFluid = json.has("result_fluid") ? JsonHelpers.getFluidStack(json.getAsJsonObject("result_fluid")) : FluidStack.EMPTY;
            float temperature = JsonHelpers.m_13915_((JsonObject)json, (String)"temperature");
            boolean useDurability = JsonHelpers.m_13855_((JsonObject)json, (String)"use_durability", (boolean)false);
            float chance = JsonHelpers.m_13820_((JsonObject)json, (String)"chance", (float)1.0f);
            return new HeatingRecipe(recipeId, ingredient, outputItem, outputFluid, temperature, useDurability, chance);
        }

        @Nullable
        public HeatingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStackProvider outputItem = ItemStackProvider.fromNetwork(buffer);
            FluidStack outputFluid = buffer.readFluidStack();
            float temperature = buffer.readFloat();
            boolean useDurability = buffer.readBoolean();
            float chance = buffer.readFloat();
            return new HeatingRecipe(recipeId, ingredient, outputItem, outputFluid, temperature, useDurability, chance);
        }

        public void toNetwork(FriendlyByteBuf buffer, HeatingRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            recipe.outputItem.toNetwork(buffer);
            buffer.writeFluidStack(recipe.outputFluid);
            buffer.writeFloat(recipe.temperature);
            buffer.writeBoolean(recipe.useDurability);
            buffer.writeFloat(recipe.chance);
        }
    }
}

